/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.flows.llmflows;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.adk.JsonBaseModel;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LlmAgent;
import com.google.adk.events.Event;
import com.google.adk.flows.llmflows.RequestProcessor;
import com.google.adk.models.LlmRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class Contents
implements RequestProcessor {
    @Override
    public Single<RequestProcessor.RequestProcessingResult> processRequest(InvocationContext context, LlmRequest request) {
        if (!(context.agent() instanceof LlmAgent)) {
            return Single.just((Object)RequestProcessor.RequestProcessingResult.create(request, context.session().events()));
        }
        LlmAgent llmAgent = (LlmAgent)context.agent();
        if (llmAgent.includeContents() == LlmAgent.IncludeContents.NONE) {
            return Single.just((Object)RequestProcessor.RequestProcessingResult.create(request.toBuilder().contents((List<Content>)this.getCurrentTurnContents(context.branch(), context.session().events(), context.agent().name())).build(), (Iterable<Event>)ImmutableList.of()));
        }
        ImmutableList<Content> contents = this.getContents(context.branch(), context.session().events(), context.agent().name());
        return Single.just((Object)RequestProcessor.RequestProcessingResult.create(request.toBuilder().contents((List<Content>)contents).build(), (Iterable<Event>)ImmutableList.of()));
    }

    private ImmutableList<Content> getCurrentTurnContents(Optional<String> currentBranch, List<Event> events, String agentName) {
        for (int i = events.size() - 1; i >= 0; --i) {
            Event event = events.get(i);
            if (!event.author().equals("user") && !Contents.isOtherAgentReply(agentName, event)) continue;
            return this.getContents(currentBranch, events.subList(i, events.size()), agentName);
        }
        return ImmutableList.of();
    }

    private ImmutableList<Content> getContents(Optional<String> currentBranch, List<Event> events, String agentName) {
        ArrayList<Event> filteredEvents = new ArrayList<Event>();
        for (Event event : events) {
            Content content;
            if (event.content().isEmpty() || (content = event.content().get()).role().isEmpty() || ((String)content.role().get()).isEmpty() || content.parts().isEmpty() || ((List)content.parts().get()).isEmpty() || ((Part)((List)content.parts().get()).get(0)).text().map(String::isEmpty).orElse(false).booleanValue() || !Contents.isEventBelongsToBranch(currentBranch, event)) continue;
            if (Contents.isOtherAgentReply(agentName, event)) {
                filteredEvents.add(Contents.convertForeignEvent(event));
                continue;
            }
            filteredEvents.add(event);
        }
        List<Event> resultEvents = Contents.rearrangeEventsForLatestFunctionResponse(filteredEvents);
        resultEvents = Contents.rearrangeEventsForAsyncFunctionResponsesInHistory(resultEvents);
        return (ImmutableList)resultEvents.stream().map(Event::content).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
    }

    private static boolean isOtherAgentReply(String agentName, Event event) {
        return !agentName.isEmpty() && !event.author().equals(agentName) && !event.author().equals("user");
    }

    private static Event convertForeignEvent(Event event) {
        if (event.content().isEmpty() || event.content().get().parts().isEmpty() || ((List)event.content().get().parts().get()).isEmpty()) {
            return event;
        }
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(Part.fromText((String)"For context:"));
        String originalAuthor = event.author();
        for (Part part : (List)event.content().get().parts().get()) {
            if (part.text().isPresent() && !((String)part.text().get()).isEmpty() && !part.thought().orElse(false).booleanValue()) {
                parts.add(Part.fromText((String)String.format("[%s] said: %s", originalAuthor, part.text().get())));
                continue;
            }
            if (part.functionCall().isPresent()) {
                FunctionCall functionCall = (FunctionCall)part.functionCall().get();
                parts.add(Part.fromText((String)String.format("[%s] called tool `%s` with parameters: %s", originalAuthor, functionCall.name().orElse("unknown_tool"), functionCall.args().map(Contents::convertMapToJson).orElse("{}"))));
                continue;
            }
            if (part.functionResponse().isPresent()) {
                FunctionResponse functionResponse = (FunctionResponse)part.functionResponse().get();
                parts.add(Part.fromText((String)String.format("[%s] `%s` tool returned result: %s", originalAuthor, functionResponse.name().orElse("unknown_tool"), functionResponse.response().map(Contents::convertMapToJson).orElse("{}"))));
                continue;
            }
            parts.add(part);
        }
        Content content = Content.builder().role("user").parts(parts).build();
        return event.toBuilder().author("user").content(content).build();
    }

    private static String convertMapToJson(Map<String, Object> struct) {
        try {
            return JsonBaseModel.getMapper().writeValueAsString(struct);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to serialize the object to JSON.", e);
        }
    }

    private static boolean isEventBelongsToBranch(Optional<String> invocationBranchOpt, Event event) {
        Optional<String> eventBranchOpt = event.branch();
        if (invocationBranchOpt.isEmpty() || invocationBranchOpt.get().isEmpty()) {
            return true;
        }
        if (eventBranchOpt.isEmpty() || eventBranchOpt.get().isEmpty()) {
            return true;
        }
        return invocationBranchOpt.get().startsWith(eventBranchOpt.get());
    }

    private static List<Event> rearrangeEventsForLatestFunctionResponse(List<Event> events) {
        Event penultimateEvent;
        boolean matchFound;
        if (events.isEmpty() || ((Event)Iterables.getLast(events)).functionResponses().isEmpty()) {
            return events;
        }
        Event latestEvent = (Event)Iterables.getLast(events);
        HashSet functionResponseIds = new HashSet();
        latestEvent.content().flatMap(Content::parts).ifPresent(parts -> {
            for (Part part : parts) {
                part.functionResponse().flatMap(FunctionResponse::id).ifPresent(functionResponseIds::add);
            }
        });
        if (functionResponseIds.isEmpty()) {
            return events;
        }
        if (events.size() >= 2 && (matchFound = (penultimateEvent = events.get(events.size() - 2)).content().flatMap(Content::parts).map(parts -> {
            for (Part part : parts) {
                if (!part.functionCall().flatMap(FunctionCall::id).map(functionResponseIds::contains).orElse(false).booleanValue()) continue;
                return true;
            }
            return false;
        }).orElse(false).booleanValue())) {
            return events;
        }
        int functionCallEventIndex = -1;
        for (int i = events.size() - 3; i >= 0; --i) {
            Event event = events.get(i);
            Optional partsOptional = event.content().flatMap(Content::parts);
            if (partsOptional.isPresent()) {
                List parts2 = (List)partsOptional.get();
                for (Part part : parts2) {
                    Optional callIdOpt = part.functionCall().flatMap(FunctionCall::id);
                    if (!callIdOpt.isPresent() || !functionResponseIds.contains(callIdOpt.get())) continue;
                    functionCallEventIndex = i;
                    parts2.forEach(p -> p.functionCall().flatMap(FunctionCall::id).ifPresent(functionResponseIds::add));
                    break;
                }
            }
            if (functionCallEventIndex != -1) break;
        }
        if (functionCallEventIndex == -1) {
            if (!functionResponseIds.isEmpty()) {
                throw new IllegalStateException("No function call event found for function response IDs: " + functionResponseIds);
            }
            return events;
        }
        ArrayList<Event> resultEvents = new ArrayList<Event>(events.subList(0, functionCallEventIndex + 1));
        ArrayList<Event> functionResponseEventsToMerge = new ArrayList<Event>();
        for (int i = functionCallEventIndex + 1; i < events.size() - 1; ++i) {
            Event intermediateEvent = events.get(i);
            boolean hasMatchingResponse = intermediateEvent.content().flatMap(Content::parts).map(parts -> {
                for (Part part : parts) {
                    if (!part.functionResponse().flatMap(FunctionResponse::id).map(functionResponseIds::contains).orElse(false).booleanValue()) continue;
                    return true;
                }
                return false;
            }).orElse(false);
            if (!hasMatchingResponse) continue;
            functionResponseEventsToMerge.add(intermediateEvent);
        }
        functionResponseEventsToMerge.add(latestEvent);
        if (!functionResponseEventsToMerge.isEmpty()) {
            resultEvents.add(Contents.mergeFunctionResponseEvents(functionResponseEventsToMerge));
        }
        return resultEvents;
    }

    private static List<Event> rearrangeEventsForAsyncFunctionResponsesInHistory(List<Event> events) {
        HashMap functionCallIdToResponseEventIndex = new HashMap();
        int i = 0;
        while (i < events.size()) {
            int index = i++;
            Event event = events.get(index);
            event.content().flatMap(Content::parts).ifPresent(parts -> {
                for (Part part : parts) {
                    part.functionResponse().ifPresent(response -> response.id().ifPresent(functionCallId -> functionCallIdToResponseEventIndex.put(functionCallId, index)));
                }
            });
        }
        ArrayList<Event> resultEvents = new ArrayList<Event>();
        HashSet<Integer> processedResponseIndices = new HashSet<Integer>();
        for (int i2 = 0; i2 < events.size(); ++i2) {
            Event event = events.get(i2);
            if (processedResponseIndices.contains(i2)) continue;
            Optional<Boolean> partsOptional = event.content().flatMap(Content::parts);
            boolean hasFunctionCalls = partsOptional.map(parts -> parts.stream().anyMatch(p -> p.functionCall().isPresent())).orElse(false);
            if (hasFunctionCalls) {
                HashSet responseEventIndices = new HashSet();
                ((List)partsOptional.get()).forEach(part -> part.functionCall().ifPresent(call -> call.id().ifPresent(functionCallId -> {
                    if (functionCallIdToResponseEventIndex.containsKey(functionCallId)) {
                        responseEventIndices.add((Integer)functionCallIdToResponseEventIndex.get(functionCallId));
                    }
                })));
                resultEvents.add(event);
                if (responseEventIndices.isEmpty()) continue;
                ArrayList<Event> responseEventsToAdd = new ArrayList<Event>();
                ArrayList sortedIndices = new ArrayList(responseEventIndices);
                Collections.sort(sortedIndices);
                Iterator iterator = sortedIndices.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    if (!processedResponseIndices.add(index)) continue;
                    responseEventsToAdd.add(events.get(index));
                }
                if (responseEventsToAdd.size() == 1) {
                    resultEvents.add((Event)responseEventsToAdd.get(0));
                    continue;
                }
                if (responseEventsToAdd.size() <= 1) continue;
                resultEvents.add(Contents.mergeFunctionResponseEvents(responseEventsToAdd));
                continue;
            }
            resultEvents.add(event);
        }
        return resultEvents;
    }

    private static Event mergeFunctionResponseEvents(List<Event> functionResponseEvents) {
        if (functionResponseEvents.isEmpty()) {
            throw new IllegalArgumentException("At least one functionResponse event is required.");
        }
        if (functionResponseEvents.size() == 1) {
            return functionResponseEvents.get(0);
        }
        Event baseEvent = functionResponseEvents.get(0);
        Content baseContent = baseEvent.content().orElseThrow(() -> new IllegalArgumentException("Base event must have content."));
        List baseParts = (List)baseContent.parts().orElseThrow(() -> new IllegalArgumentException("Base event content must have parts."));
        if (baseParts.isEmpty()) {
            throw new IllegalArgumentException("There should be at least one functionResponse part in the base event.");
        }
        ArrayList<Part> partsInMergedEvent = new ArrayList<Part>(baseParts);
        HashMap<String, Integer> partIndicesInMergedEvent = new HashMap<String, Integer>();
        for (int i = 0; i < partsInMergedEvent.size(); ++i) {
            int index = i;
            Part part = (Part)partsInMergedEvent.get(i);
            if (!part.functionResponse().isPresent()) continue;
            ((FunctionResponse)part.functionResponse().get()).id().ifPresent(functionCallId -> partIndicesInMergedEvent.put((String)functionCallId, index));
        }
        for (Event event : functionResponseEvents.subList(1, functionResponseEvents.size())) {
            if (!Contents.hasContentWithNonEmptyParts(event)) continue;
            for (Part part : (List)event.content().get().parts().get()) {
                if (part.functionResponse().isPresent()) {
                    Optional functionCallIdOpt = ((FunctionResponse)part.functionResponse().get()).id();
                    if (functionCallIdOpt.isPresent()) {
                        String functionCallId2 = (String)functionCallIdOpt.get();
                        if (partIndicesInMergedEvent.containsKey(functionCallId2)) {
                            partsInMergedEvent.set((Integer)partIndicesInMergedEvent.get(functionCallId2), part);
                            continue;
                        }
                        partsInMergedEvent.add(part);
                        partIndicesInMergedEvent.put(functionCallId2, partsInMergedEvent.size() - 1);
                        continue;
                    }
                    partsInMergedEvent.add(part);
                    continue;
                }
                partsInMergedEvent.add(part);
            }
        }
        return baseEvent.toBuilder().content(Optional.of(Content.builder().role((String)baseContent.role().get()).parts(partsInMergedEvent).build())).build();
    }

    private static boolean hasContentWithNonEmptyParts(Event event) {
        return event.content().flatMap(Content::parts).map(list -> !list.isEmpty()).orElse(false);
    }
}

