/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.events;

import com.google.adk.events.Event;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class EventStream
implements Iterable<Event> {
    private final Supplier<Event> eventSupplier;

    public EventStream(Supplier<Event> eventSupplier) {
        this.eventSupplier = eventSupplier;
    }

    @Override
    public Iterator<Event> iterator() {
        return new EventIterator();
    }

    private class EventIterator
    implements Iterator<Event> {
        private Event nextEvent = null;
        private boolean finished = false;

        private EventIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.finished) {
                return false;
            }
            if (this.nextEvent == null) {
                this.nextEvent = EventStream.this.eventSupplier.get();
                this.finished = this.nextEvent == null;
            }
            return !this.finished;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more events.");
            }
            Event currentEvent = this.nextEvent;
            this.nextEvent = null;
            return currentEvent;
        }
    }
}

