/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.adk.JsonBaseModel;
import com.google.adk.events.EventActions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.types.Content;
import com.google.genai.types.FinishReason;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.GroundingMetadata;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public class Event
extends JsonBaseModel {
    private String id;
    private String invocationId;
    private String author;
    private Optional<Content> content = Optional.empty();
    private EventActions actions;
    private Optional<Set<String>> longRunningToolIds = Optional.empty();
    private Optional<Boolean> partial = Optional.empty();
    private Optional<Boolean> turnComplete = Optional.empty();
    private Optional<FinishReason> errorCode = Optional.empty();
    private Optional<String> errorMessage = Optional.empty();
    private Optional<Boolean> interrupted = Optional.empty();
    private Optional<String> branch = Optional.empty();
    private Optional<GroundingMetadata> groundingMetadata = Optional.empty();
    private long timestamp;

    private Event() {
    }

    public static String generateEventId() {
        return UUID.randomUUID().toString();
    }

    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="invocationId")
    public String invocationId() {
        return this.invocationId;
    }

    public void setInvocationId(String invocationId) {
        this.invocationId = invocationId;
    }

    @JsonProperty(value="author")
    public String author() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @JsonProperty(value="content")
    public Optional<Content> content() {
        return this.content;
    }

    public void setContent(Optional<Content> content) {
        this.content = content;
    }

    @JsonProperty(value="actions")
    public EventActions actions() {
        return this.actions;
    }

    public void setActions(EventActions actions) {
        this.actions = actions;
    }

    @JsonProperty(value="longRunningToolIds")
    public Optional<Set<String>> longRunningToolIds() {
        return this.longRunningToolIds;
    }

    public void setLongRunningToolIds(Optional<Set<String>> longRunningToolIds) {
        this.longRunningToolIds = longRunningToolIds;
    }

    @JsonProperty(value="partial")
    public Optional<Boolean> partial() {
        return this.partial;
    }

    public void setPartial(Optional<Boolean> partial) {
        this.partial = partial;
    }

    @JsonProperty(value="turnComplete")
    public Optional<Boolean> turnComplete() {
        return this.turnComplete;
    }

    public void setTurnComplete(Optional<Boolean> turnComplete) {
        this.turnComplete = turnComplete;
    }

    @JsonProperty(value="errorCode")
    public Optional<FinishReason> errorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Optional<FinishReason> errorCode) {
        this.errorCode = errorCode;
    }

    @JsonProperty(value="errorMessage")
    public Optional<String> errorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(Optional<String> errorMessage) {
        this.errorMessage = errorMessage;
    }

    @JsonProperty(value="interrupted")
    public Optional<Boolean> interrupted() {
        return this.interrupted;
    }

    public void setInterrupted(Optional<Boolean> interrupted) {
        this.interrupted = interrupted;
    }

    @JsonProperty(value="branch")
    public Optional<String> branch() {
        return this.branch;
    }

    public void branch(@Nullable String branch) {
        this.branch = Optional.ofNullable(branch);
    }

    public void branch(Optional<String> branch) {
        this.branch = branch;
    }

    @JsonProperty(value="groundingMetadata")
    public Optional<GroundingMetadata> groundingMetadata() {
        return this.groundingMetadata;
    }

    public void setGroundingMetadata(Optional<GroundingMetadata> groundingMetadata) {
        this.groundingMetadata = groundingMetadata;
    }

    @JsonProperty(value="timestamp")
    public long timestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonIgnore
    public final ImmutableList<FunctionCall> functionCalls() {
        return (ImmutableList)this.content().flatMap(Content::parts).stream().flatMap(Collection::stream).flatMap(part -> part.functionCall().stream()).collect(ImmutableList.toImmutableList());
    }

    @JsonIgnore
    public final ImmutableList<FunctionResponse> functionResponses() {
        return (ImmutableList)this.content().flatMap(Content::parts).stream().flatMap(Collection::stream).flatMap(part -> part.functionResponse().stream()).collect(ImmutableList.toImmutableList());
    }

    @JsonIgnore
    public final boolean finalResponse() {
        if (this.actions().skipSummarization().orElse(false).booleanValue() || this.longRunningToolIds().isPresent() && !this.longRunningToolIds().get().isEmpty()) {
            return true;
        }
        return this.functionCalls().isEmpty() && this.functionResponses().isEmpty() && this.partial().orElse(false) == false;
    }

    public final String stringifyContent() {
        StringBuilder sb = new StringBuilder();
        this.content().flatMap(Content::parts).stream().flatMap(Collection::stream).forEach(part -> {
            part.text().ifPresent(sb::append);
            part.functionCall().ifPresent(functionCall -> sb.append("Function Call: ").append(functionCall));
            part.functionResponse().ifPresent(functionResponse -> sb.append("Function Response: ").append(functionResponse));
        });
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Event fromJson(String json) {
        return Event.fromJsonString(json, Event.class);
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.id).invocationId(this.invocationId).author(this.author).content(this.content).actions(this.actions).longRunningToolIds(this.longRunningToolIds).partial(this.partial).turnComplete(this.turnComplete).errorCode(this.errorCode).errorMessage(this.errorMessage).interrupted(this.interrupted).branch(this.branch).groundingMetadata(this.groundingMetadata);
        if (this.timestamp != 0L) {
            builder.timestamp(this.timestamp);
        }
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return this.timestamp == other.timestamp && Objects.equals(this.id, other.id) && Objects.equals(this.invocationId, other.invocationId) && Objects.equals(this.author, other.author) && Objects.equals(this.content, other.content) && Objects.equals(this.actions, other.actions) && Objects.equals(this.longRunningToolIds, other.longRunningToolIds) && Objects.equals(this.partial, other.partial) && Objects.equals(this.turnComplete, other.turnComplete) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.interrupted, other.interrupted) && Objects.equals(this.branch, other.branch) && Objects.equals(this.groundingMetadata, other.groundingMetadata);
    }

    public String toString() {
        return this.toJson();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.invocationId, this.author, this.content, this.actions, this.longRunningToolIds, this.partial, this.turnComplete, this.errorCode, this.errorMessage, this.interrupted, this.branch, this.groundingMetadata, this.timestamp);
    }

    public static class Builder {
        private String id;
        private String invocationId;
        private String author;
        private Optional<Content> content = Optional.empty();
        private EventActions actions;
        private Optional<Set<String>> longRunningToolIds = Optional.empty();
        private Optional<Boolean> partial = Optional.empty();
        private Optional<Boolean> turnComplete = Optional.empty();
        private Optional<FinishReason> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();
        private Optional<Boolean> interrupted = Optional.empty();
        private Optional<String> branch = Optional.empty();
        private Optional<GroundingMetadata> groundingMetadata = Optional.empty();
        private Optional<Long> timestamp = Optional.empty();

        @JsonCreator
        private static Builder create() {
            return new Builder();
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public Builder id(String value) {
            this.id = value;
            return this;
        }

        @JsonProperty(value="invocationId")
        @CanIgnoreReturnValue
        public Builder invocationId(String value) {
            this.invocationId = value;
            return this;
        }

        @JsonProperty(value="author")
        @CanIgnoreReturnValue
        public Builder author(String value) {
            this.author = value;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public Builder content(@Nullable Content value) {
            this.content = Optional.ofNullable(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(Optional<Content> value) {
            this.content = value;
            return this;
        }

        @JsonProperty(value="actions")
        @CanIgnoreReturnValue
        public Builder actions(EventActions value) {
            this.actions = value;
            return this;
        }

        Optional<EventActions> actions() {
            return Optional.ofNullable(this.actions);
        }

        @JsonProperty(value="longRunningToolIds")
        @CanIgnoreReturnValue
        public Builder longRunningToolIds(@Nullable Set<String> value) {
            this.longRunningToolIds = Optional.ofNullable(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder longRunningToolIds(Optional<Set<String>> value) {
            this.longRunningToolIds = value;
            return this;
        }

        @JsonProperty(value="partial")
        @CanIgnoreReturnValue
        public Builder partial(@Nullable Boolean value) {
            this.partial = Optional.ofNullable(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder partial(Optional<Boolean> value) {
            this.partial = value;
            return this;
        }

        @JsonProperty(value="turnComplete")
        @CanIgnoreReturnValue
        public Builder turnComplete(@Nullable Boolean value) {
            this.turnComplete = Optional.ofNullable(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder turnComplete(Optional<Boolean> value) {
            this.turnComplete = value;
            return this;
        }

        @JsonProperty(value="errorCode")
        @CanIgnoreReturnValue
        public Builder errorCode(@Nullable FinishReason value) {
            this.errorCode = Optional.ofNullable(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder errorCode(Optional<FinishReason> value) {
            this.errorCode = value;
            return this;
        }

        @JsonProperty(value="errorMessage")
        @CanIgnoreReturnValue
        public Builder errorMessage(@Nullable String value) {
            this.errorMessage = Optional.ofNullable(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder errorMessage(Optional<String> value) {
            this.errorMessage = value;
            return this;
        }

        @JsonProperty(value="interrupted")
        @CanIgnoreReturnValue
        public Builder interrupted(@Nullable Boolean value) {
            this.interrupted = Optional.ofNullable(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder interrupted(Optional<Boolean> value) {
            this.interrupted = value;
            return this;
        }

        @JsonProperty(value="timestamp")
        @CanIgnoreReturnValue
        public Builder timestamp(long value) {
            this.timestamp = Optional.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder timestamp(Optional<Long> value) {
            this.timestamp = value;
            return this;
        }

        Optional<Long> timestamp() {
            return this.timestamp;
        }

        @JsonProperty(value="branch")
        @CanIgnoreReturnValue
        public Builder branch(@Nullable String value) {
            this.branch = Optional.ofNullable(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder branch(Optional<String> value) {
            this.branch = value;
            return this;
        }

        Optional<String> branch() {
            return this.branch;
        }

        @JsonProperty(value="groundingMetadata")
        @CanIgnoreReturnValue
        public Builder groundingMetadata(@Nullable GroundingMetadata value) {
            this.groundingMetadata = Optional.ofNullable(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder groundingMetadata(Optional<GroundingMetadata> value) {
            this.groundingMetadata = value;
            return this;
        }

        Optional<GroundingMetadata> groundingMetadata() {
            return this.groundingMetadata;
        }

        public Event build() {
            Event event = new Event();
            event.setId(this.id);
            event.setInvocationId(this.invocationId);
            event.setAuthor(this.author);
            event.setContent(this.content);
            event.setLongRunningToolIds(this.longRunningToolIds);
            event.setPartial(this.partial);
            event.setTurnComplete(this.turnComplete);
            event.setErrorCode(this.errorCode);
            event.setErrorMessage(this.errorMessage);
            event.setInterrupted(this.interrupted);
            event.branch(this.branch);
            event.setGroundingMetadata(this.groundingMetadata);
            event.setActions(this.actions().orElse(EventActions.builder().build()));
            event.setTimestamp(this.timestamp().orElse(Instant.now().toEpochMilli()));
            return event;
        }
    }
}

