/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.codeexecutors;

import com.google.adk.codeexecutors.CodeExecutionUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

final class AutoValue_CodeExecutionUtils_CodeExecutionInput
extends CodeExecutionUtils.CodeExecutionInput {
    private final String code;
    private final ImmutableList<CodeExecutionUtils.File> inputFiles;
    private final Optional<String> executionId;

    private AutoValue_CodeExecutionUtils_CodeExecutionInput(String code, ImmutableList<CodeExecutionUtils.File> inputFiles, Optional<String> executionId) {
        this.code = code;
        this.inputFiles = inputFiles;
        this.executionId = executionId;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public ImmutableList<CodeExecutionUtils.File> inputFiles() {
        return this.inputFiles;
    }

    @Override
    public Optional<String> executionId() {
        return this.executionId;
    }

    public String toString() {
        return "CodeExecutionInput{code=" + this.code + ", inputFiles=" + this.inputFiles + ", executionId=" + this.executionId + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CodeExecutionUtils.CodeExecutionInput) {
            CodeExecutionUtils.CodeExecutionInput that = (CodeExecutionUtils.CodeExecutionInput)o;
            return this.code.equals(that.code()) && this.inputFiles.equals(that.inputFiles()) && this.executionId.equals(that.executionId());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.code.hashCode();
        h$ *= 1000003;
        h$ ^= this.inputFiles.hashCode();
        h$ *= 1000003;
        return h$ ^= this.executionId.hashCode();
    }

    static final class Builder
    extends CodeExecutionUtils.CodeExecutionInput.Builder {
        private String code;
        private ImmutableList<CodeExecutionUtils.File> inputFiles;
        private Optional<String> executionId = Optional.empty();

        Builder() {
        }

        @Override
        public CodeExecutionUtils.CodeExecutionInput.Builder code(String code) {
            if (code == null) {
                throw new NullPointerException("Null code");
            }
            this.code = code;
            return this;
        }

        @Override
        public CodeExecutionUtils.CodeExecutionInput.Builder inputFiles(List<CodeExecutionUtils.File> inputFiles) {
            this.inputFiles = ImmutableList.copyOf(inputFiles);
            return this;
        }

        @Override
        public CodeExecutionUtils.CodeExecutionInput.Builder executionId(Optional<String> executionId) {
            if (executionId == null) {
                throw new NullPointerException("Null executionId");
            }
            this.executionId = executionId;
            return this;
        }

        @Override
        public CodeExecutionUtils.CodeExecutionInput build() {
            if (this.code == null || this.inputFiles == null) {
                StringBuilder missing = new StringBuilder();
                if (this.code == null) {
                    missing.append(" code");
                }
                if (this.inputFiles == null) {
                    missing.append(" inputFiles");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CodeExecutionUtils_CodeExecutionInput(this.code, this.inputFiles, this.executionId);
        }
    }
}

