/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.adk.JsonBaseModel;
import com.google.genai.types.Schema;
import com.google.genai.types.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SchemaUtils {
    private SchemaUtils() {
    }

    private static Boolean matchType(Object value, Schema schema, Boolean isInput) {
        Type.Known type = ((Type)schema.type().get()).knownEnum();
        switch (type) {
            case STRING: {
                return value instanceof String;
            }
            case INTEGER: {
                return value instanceof Integer;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case NUMBER: {
                return value instanceof Number;
            }
            case ARRAY: {
                if (value instanceof List) {
                    for (Object element : (List)value) {
                        if (SchemaUtils.matchType(element, (Schema)schema.items().get(), isInput).booleanValue()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            case OBJECT: {
                if (value instanceof Map) {
                    SchemaUtils.validateMapOnSchema((Map)value, schema, isInput);
                    return true;
                }
                return false;
            }
            case TYPE_UNSPECIFIED: {
                throw new IllegalArgumentException("Unsupported type: " + type + " is not a Open API data type.");
            }
        }
        return false;
    }

    public static void validateMapOnSchema(Map<String, Object> args, Schema schema, Boolean isInput) {
        Map properties = (Map)schema.properties().get();
        for (Map.Entry<String, Object> arg : args.entrySet()) {
            if (!properties.containsKey(arg.getKey())) {
                if (isInput.booleanValue()) {
                    throw new IllegalArgumentException("Input arg: " + arg.getKey() + " does not match agent input schema: " + schema);
                }
                throw new IllegalArgumentException("Output arg: " + arg.getKey() + " does not match agent output schema: " + schema);
            }
            if (SchemaUtils.matchType(arg.getValue(), (Schema)properties.get(arg.getKey()), isInput).booleanValue()) continue;
            if (isInput.booleanValue()) {
                throw new IllegalArgumentException("Input arg: " + arg.getKey() + " does not match agent input schema: " + schema);
            }
            throw new IllegalArgumentException("Output arg: " + arg.getKey() + " does not match agent output schema: " + schema);
        }
        if (schema.required().isPresent()) {
            for (String required : (List)schema.required().get()) {
                if (args.containsKey(required)) continue;
                if (isInput.booleanValue()) {
                    throw new IllegalArgumentException("Input args does not contain required " + required);
                }
                throw new IllegalArgumentException("Output args does not contain required " + required);
            }
        }
    }

    public static Map<String, Object> validateOutputSchema(String output, Schema schema) throws JsonProcessingException {
        Map outputMap = (Map)JsonBaseModel.getMapper().readValue(output, HashMap.class);
        SchemaUtils.validateMapOnSchema(outputMap, schema, false);
        return outputMap;
    }
}

