/*
 * Decompiled with CFR 0.152.
 */
package com.github.goldfish.zamad;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.github.goldfish.zamad.ClickListener;
import com.google.android.gms.ads.AdView;

public class ZamAd
implements ClickListener {
    private Context context;
    private static String ZAM_ADS_KEY = "ZamAds";
    private int click_count = 0;
    private static int max_click = 2;
    private boolean isad_disabled = false;
    private SharedPreferences prefs;
    private SharedPreferences.Editor editor;

    @SuppressLint(value={"CommitPrefEdits"})
    public ZamAd(Context context) {
        this.context = context;
        this.prefs = this.context.getSharedPreferences(ZAM_ADS_KEY, 0);
        this.editor = this.prefs.edit();
    }

    public ZamAd initialize() {
        this.click_count = this.prefs.getInt("click_count", this.click_count);
        this.isad_disabled = this.prefs.getBoolean("disable_ads", this.isad_disabled);
        return this;
    }

    @Override
    public void onClicked(int count, @Nullable AdView adView) {
        ++this.click_count;
        this.editor.putInt("click_count", count).apply();
        if (adView != null) {
            this.check_ClickThreshold(adView);
        }
    }

    @Override
    public void onDestroyClickReset() {
        if (this.click_count < max_click) {
            this.editor.putInt("click_count", 0).apply();
        }
    }

    public int getClickedCount() {
        return this.click_count;
    }

    public void check_ClickThreshold(AdView adView) {
        if (this.getClickedCount() > max_click) {
            if (adView != null) {
                adView.destroy();
            }
            this.editor.putBoolean("disable_ads", true).apply();
        }
    }

    public boolean isAdClosed() {
        return this.isad_disabled;
    }
}

