/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.compositejks;

import com.oneandone.compositejks.CompositeX509KeyManager;
import com.oneandone.compositejks.CompositeX509TrustManager;
import com.oneandone.compositejks.KeyManagerAlgorithmStep;
import com.oneandone.compositejks.KeyManagerPasswordStep;
import com.oneandone.compositejks.KeyStoreStep;
import com.oneandone.compositejks.ProtocolStep;
import com.oneandone.compositejks.SslContextStep;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public final class SslContextBuilder
implements KeyStoreStep,
KeyManagerAlgorithmStep,
KeyManagerPasswordStep,
ProtocolStep,
SslContextStep {
    private char[] keyStorePassword;
    private KeyStore keyStore;
    private String socketProtocol;
    private String keyManagerAlgorithm;
    private char[] keyManagerPassword;

    private SslContextBuilder() {
    }

    public static KeyStoreStep builder() {
        return new SslContextBuilder();
    }

    @Override
    public ProtocolStep keyStoreFromStream(InputStream stream, String password) throws IOException, GeneralSecurityException {
        this.keyStorePassword = password == null ? null : password.toCharArray();
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.keyStore.load(stream, this.keyStorePassword);
        return this;
    }

    @Override
    public KeyManagerAlgorithmStep usingProtocol(String socketProtocol) {
        this.socketProtocol = socketProtocol;
        return this;
    }

    @Override
    public KeyManagerPasswordStep usingAlgorithm(String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : keyManagerAlgorithm;
        return this;
    }

    @Override
    public SslContextStep usingKeyManagerPassword(String keyManagerPwd) {
        this.keyManagerPassword = keyManagerPwd == null ? this.keyStorePassword : keyManagerPwd.toCharArray();
        return this;
    }

    @Override
    public SSLContext buildMergedWithSystem() throws GeneralSecurityException {
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManager[] keyManagers = new KeyManager[]{new CompositeX509KeyManager(SslContextBuilder.union(SslContextBuilder.getSystemKeyManagers(this.keyManagerAlgorithm, this.keyStore, this.keyManagerPassword), SslContextBuilder.getSystemKeyManagers(defaultAlgorithm, null, null)))};
        TrustManager[] trustManagers = new TrustManager[]{new CompositeX509TrustManager(SslContextBuilder.union(SslContextBuilder.getSystemTrustManagers(this.keyManagerAlgorithm, this.keyStore), SslContextBuilder.getSystemTrustManagers(defaultAlgorithm, null)))};
        SSLContext context = SSLContext.getInstance(this.socketProtocol);
        context.init(keyManagers, trustManagers, null);
        return context;
    }

    private static List<X509KeyManager> getSystemKeyManagers(String algorithm, KeyStore keystore, char[] password) throws GeneralSecurityException {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        factory.init(keystore, password);
        return Arrays.stream(factory.getKeyManagers()).filter(x -> x instanceof X509KeyManager).map(x -> (X509KeyManager)x).collect(Collectors.toList());
    }

    private static List<X509TrustManager> getSystemTrustManagers(String algorithm, KeyStore keystore) throws GeneralSecurityException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
        factory.init(keystore);
        return Arrays.stream(factory.getTrustManagers()).filter(x -> x instanceof X509TrustManager).map(x -> (X509TrustManager)x).collect(Collectors.toList());
    }

    private static <T> List<T> union(List<T> col1, List<T> col2) {
        ArrayList<T> newList = new ArrayList<T>(col1);
        newList.addAll(col2);
        return newList;
    }
}

