/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.compositejks;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class CompositeX509TrustManager
implements X509TrustManager {
    private final List<X509TrustManager> children;

    public CompositeX509TrustManager(List<X509TrustManager> children) {
        this.children = children;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(x -> x.checkClientTrusted(chain, authType));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(x -> x.checkServerTrusted(chain, authType));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])this.children.stream().flatMap(x -> Arrays.stream(x.getAcceptedIssuers())).toArray(X509Certificate[]::new);
    }

    private void checkTrusted(ThrowingProcessor processor) throws CertificateException {
        CertificateException lastError = null;
        for (X509TrustManager manager : this.children) {
            try {
                processor.process(manager);
                return;
            }
            catch (CertificateException ex) {
                lastError = ex;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
    }

    private static interface ThrowingProcessor {
        public void process(X509TrustManager var1) throws CertificateException;
    }
}

