/*
 * Decompiled with CFR 0.152.
 */
package gs.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.FloatRange;
import android.support.v7.preference.PreferenceViewHolder;
import android.support.v7.preference.R;
import android.support.v7.preference.SeekBarPreference;
import android.util.AttributeSet;
import android.widget.SeekBar;
import gs.preference.SmoothOnSeekBarChangeWrapper;
import gs.preference.seekbar.R;
import java.lang.reflect.Field;

public class PercentSeekBarPreferenceCompat
extends SeekBarPreference {
    private boolean mSmooth;

    public PercentSeekBarPreferenceCompat(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SeekBarPreference, defStyleAttr, defStyleRes);
        try {
            this.mSmooth = a.getBoolean(R.styleable.SeekBarPreference_smooth, true);
        }
        finally {
            a.recycle();
        }
    }

    public PercentSeekBarPreferenceCompat(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public PercentSeekBarPreferenceCompat(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, R.attr.seekBarPreferenceStyle, 0);
    }

    public PercentSeekBarPreferenceCompat(Context context) {
        super(context);
        this.init(context, null, R.attr.seekBarPreferenceStyle, 0);
    }

    public void onBindViewHolder(PreferenceViewHolder view) {
        super.onBindViewHolder(view);
        if (this.mSmooth) {
            try {
                Field field = SeekBar.class.getDeclaredField("mOnSeekBarChangeListener");
                field.setAccessible(true);
                SeekBar seekBar = (SeekBar)view.findViewById(R.id.seekbar);
                SeekBar.OnSeekBarChangeListener listener = (SeekBar.OnSeekBarChangeListener)field.get(seekBar);
                seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new SmoothOnSeekBarChangeWrapper(listener));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private int adaptValue(float value) {
        return Math.round(value * (float)this.getMax());
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        this.setValue(restoreValue ? this.adaptValue(this.getPersistedFloat(this.getPercentValue())) : ((Integer)defaultValue).intValue());
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        this.setMax(a.getInt(R.styleable.SeekBarPreference_android_max, 100));
        return this.adaptValue(a.getFloat(index, 0.0f));
    }

    protected boolean persistInt(int value) {
        return this.persistFloat(this.getPercentValue());
    }

    @FloatRange(from=0.0, to=1.0)
    public float getPercentValue() {
        float min = this.getMin();
        return ((float)this.getValue() - min) / ((float)this.getMax() - min);
    }

    public void setPercentValue(@FloatRange(from=0.0, to=1.0) float value) {
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("value must be between 0 and 1");
        }
        this.setValue(this.adaptValue(value));
    }
}

