/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mock;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.mock.Behavior;
import okhttp3.mock.Rule;
import okhttp3.mock.matchers.Matcher;

public class MockInterceptor
implements Interceptor {
    private final List<Rule> rules = new LinkedList<Rule>();
    private Behavior behavior;

    public MockInterceptor() {
        this(Behavior.SEQUENTIAL);
    }

    public MockInterceptor(Behavior behavior) {
        this.behavior = behavior;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public MockInterceptor addRule(Response.Builder builder) {
        if (!(builder instanceof Rule.Builder.FinalRuleBuilder)) {
            throw new IllegalArgumentException("This response was not created with Rule.Builder!");
        }
        this.addRule(((Rule.Builder.FinalRuleBuilder)builder).buildRule());
        return this;
    }

    public MockInterceptor addRule(Rule rule) {
        this.rules.add(rule);
        return this;
    }

    public Rule.Builder addRule() {
        return new Rule.Builder(){

            @Override
            void onBuild(Rule rule) {
                MockInterceptor.this.addRule(rule);
            }
        };
    }

    public MockInterceptor reset() {
        this.rules.clear();
        return this;
    }

    public Behavior behavior() {
        return this.behavior;
    }

    public MockInterceptor behavior(Behavior behavior) {
        this.behavior = behavior;
        return this;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        for (Rule rule : this.rules) {
            if (rule.isConsumed()) continue;
            Response response = rule.accept(request);
            if (response != null) {
                return response;
            }
            if (this.behavior != Behavior.SEQUENTIAL) continue;
            StringBuilder sb = new StringBuilder("Not matched next rule: ");
            sb.append(rule);
            sb.append(", request=");
            sb.append(request);
            sb.append("\nFailed to match:");
            int i = 0;
            for (Map.Entry<Matcher, String> e : rule.getFailReason(request).entrySet()) {
                sb.append("\n\t");
                sb.append(++i);
                sb.append(": ");
                sb.append(e.getValue());
                sb.append("; matcher=");
                sb.append(e.getKey());
            }
            throw new AssertionError((Object)sb.toString());
        }
        if (this.behavior == Behavior.RELAYED) {
            return chain.proceed(request);
        }
        StringBuilder sb = new StringBuilder("Not matched any rule: request=");
        sb.append(request);
        if (this.rules.isEmpty()) {
            sb.append("\nNo remaining rules!");
        } else {
            sb.append("\nRemaining rules:");
            int i = 0;
            for (Rule rule : this.rules) {
                sb.append("\n\t");
                sb.append(++i);
                sb.append(": ");
                sb.append(rule);
            }
        }
        throw new AssertionError((Object)sb.toString());
    }
}

