/*
 * Decompiled with CFR 0.152.
 */
package gs.maps.nestedscroll;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;

class ViewTouchHelper {
    ViewTouchHelper() {
    }

    public static boolean isTopMostView(View target, MotionEvent ev) {
        View root = target.getRootView();
        return ViewTouchHelper.isTopMostView(target, root, (int)ev.getRawX(), (int)ev.getRawY());
    }

    private static boolean isTopMostView(View target, View current, int x, int y) {
        if (current instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)current;
            int scrollX = group.getScrollX();
            int scrollY = group.getScrollY();
            for (int i = group.getChildCount() - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                int left = child.getLeft() - scrollX;
                int top = child.getTop() - scrollY;
                if (child.getVisibility() != 0 || y < top || y >= child.getBottom() - scrollY || x < left || x >= child.getRight() - scrollX) continue;
                return child == target || ViewTouchHelper.isTopMostView(target, child, x - left, y - top);
            }
        }
        return false;
    }
}

