/*
 * Decompiled with CFR 0.152.
 */
package com.gluehome.common.data.log;

import com.gluehome.common.data.log.LoggerExtraInfo;
import com.sematext.logseneandroid.Logsene;
import com.sematext.logseneandroid.Utils;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/gluehome/common/data/log/SematextTree;", "Ltimber/log/Timber$Tree;", "logsene", "Lcom/sematext/logseneandroid/Logsene;", "loggerExtraInfo", "Lcom/gluehome/common/data/log/LoggerExtraInfo;", "shouldLogDebug", "", "(Lcom/sematext/logseneandroid/Logsene;Lcom/gluehome/common/data/log/LoggerExtraInfo;Z)V", "log", "", "priority", "", "tag", "", "message", "t", "", "mapPriorityToText", "logger_release"})
@SourceDebugExtension(value={"SMAP\nSematextTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SematextTree.kt\ncom/gluehome/common/data/log/SematextTree\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,51:1\n215#2,2:52\n*S KotlinDebug\n*F\n+ 1 SematextTree.kt\ncom/gluehome/common/data/log/SematextTree\n*L\n35#1:52,2\n*E\n"})
public final class SematextTree
extends Timber.Tree {
    @NotNull
    private final Logsene logsene;
    @NotNull
    private final LoggerExtraInfo loggerExtraInfo;
    private final boolean shouldLogDebug;

    public SematextTree(@NotNull Logsene logsene, @NotNull LoggerExtraInfo loggerExtraInfo, boolean shouldLogDebug) {
        Intrinsics.checkNotNullParameter((Object)logsene, (String)"logsene");
        Intrinsics.checkNotNullParameter((Object)loggerExtraInfo, (String)"loggerExtraInfo");
        this.logsene = logsene;
        this.loggerExtraInfo = loggerExtraInfo;
        this.shouldLogDebug = shouldLogDebug;
    }

    protected void log(int priority, @Nullable String tag, @NotNull String message, @Nullable Throwable t) {
        Map<String, Object> extra;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.shouldLogDebug && priority == 3) {
            return;
        }
        Object object = new Pair[]{TuplesKt.to((Object)"level", (Object)this.mapPriorityToText(priority)), TuplesKt.to((Object)"message", (Object)message)};
        Map fullInfo = MapsKt.mutableMapOf((Pair[])object);
        if (priority == 6 && t != null) {
            object = fullInfo;
            String string = "exception";
            String string2 = t.getClass().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"t.javaClass.toString()");
            String string3 = string2;
            object.put(string, string3);
            object = fullInfo;
            string = "message";
            String string4 = t.getMessage();
            if (string4 == null) {
                string4 = "empty error message";
            }
            string3 = string4;
            object.put(string, string3);
            object = fullInfo;
            string = "localized_message";
            String string5 = t.getLocalizedMessage();
            if (string5 == null) {
                string5 = "empty localizedMessage";
            }
            string3 = string5;
            object.put(string, string3);
            object = fullInfo;
            string = "stacktrace";
            String string6 = Utils.getStackTrace((Throwable)t);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getStackTrace(t)");
            string3 = string6;
            object.put(string, string3);
        }
        Map<String, Object> $this$forEach$iv = extra = this.loggerExtraInfo.getAll();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> it = element$iv = iterator.next();
            boolean bl = false;
            fullInfo.put(it.getKey(), it.getValue());
        }
        Intrinsics.checkNotNull((Object)fullInfo, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        this.logsene.event(new JSONObject(fullInfo));
    }

    private final String mapPriorityToText(int priority) {
        return switch (priority) {
            case 4 -> "info";
            case 5 -> "warn";
            case 6 -> "error";
            default -> "debug";
        };
    }
}

