/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.hjq.permissions.IPermissionInterceptor;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class XXPermissions {
    public static final int REQUEST_CODE = 1025;
    private static IPermissionInterceptor sPermissionInterceptor;
    private static Boolean sDebugMode;
    private final FragmentActivity mActivity;
    private List<String> mPermissions;

    public static XXPermissions with(FragmentActivity activity) {
        return new XXPermissions(activity);
    }

    public static XXPermissions with(Context context) {
        return XXPermissions.with(PermissionUtils.findFragmentActivity(context));
    }

    public static XXPermissions with(Fragment fragment) {
        return XXPermissions.with(fragment.getActivity());
    }

    public static void setDebugMode(Boolean debugMode) {
        sDebugMode = debugMode;
    }

    private static boolean isDebugMode(Context context) {
        if (sDebugMode == null) {
            sDebugMode = (context.getApplicationInfo().flags & 2) != 0;
        }
        return sDebugMode;
    }

    public static void setPermissionInterceptor(IPermissionInterceptor interceptor) {
        sPermissionInterceptor = interceptor;
    }

    static IPermissionInterceptor getPermissionInterceptor() {
        if (sPermissionInterceptor == null) {
            sPermissionInterceptor = new IPermissionInterceptor(){};
        }
        return sPermissionInterceptor;
    }

    private XXPermissions(FragmentActivity activity) {
        this.mActivity = activity;
    }

    public XXPermissions permission(String permission) {
        if (this.mPermissions == null) {
            this.mPermissions = new ArrayList<String>(1);
        }
        this.mPermissions.add(permission);
        return this;
    }

    public XXPermissions permission(String[] permissions) {
        return this.permission(PermissionUtils.asArrayList(permissions));
    }

    public XXPermissions permission(List<String> permissions) {
        if (this.mPermissions == null) {
            this.mPermissions = permissions;
        } else {
            this.mPermissions.addAll(permissions);
        }
        return this;
    }

    public void request(OnPermissionCallback callback) {
        if (this.mActivity == null || this.mActivity.isFinishing() || Build.VERSION.SDK_INT >= 17 && this.mActivity.isDestroyed()) {
            return;
        }
        if (this.mPermissions == null || this.mPermissions.isEmpty()) {
            if (XXPermissions.isDebugMode((Context)this.mActivity)) {
                throw new IllegalArgumentException("The requested permission cannot be empty");
            }
            return;
        }
        if (XXPermissions.isDebugMode((Context)this.mActivity)) {
            PermissionUtils.checkStoragePermission((Context)this.mActivity, this.mPermissions);
            PermissionUtils.checkLocationPermission(this.mPermissions);
            PermissionUtils.checkTargetSdkVersion((Context)this.mActivity, this.mPermissions);
        }
        PermissionUtils.optimizeDeprecatedPermission(this.mPermissions);
        if (XXPermissions.isDebugMode((Context)this.mActivity)) {
            PermissionUtils.checkPermissionManifest((Context)this.mActivity, this.mPermissions);
        }
        if (PermissionUtils.isGrantedPermissions((Context)this.mActivity, this.mPermissions)) {
            if (callback != null) {
                callback.onGranted(this.mPermissions, true);
            }
            return;
        }
        XXPermissions.getPermissionInterceptor().requestPermissions(this.mActivity, callback, this.mPermissions);
    }

    public static boolean isGrantedPermission(Context context, String permission) {
        return PermissionUtils.isGrantedPermission(context, permission);
    }

    public static boolean isGrantedPermission(Context context, String[] permissions) {
        return XXPermissions.isGrantedPermission(context, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isGrantedPermission(Context context, List<String> permissions) {
        return PermissionUtils.isGrantedPermissions(context, permissions);
    }

    public static List<String> getDeniedPermissions(Context context, String[] permissions) {
        return XXPermissions.getDeniedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static List<String> getDeniedPermissions(Context context, List<String> permissions) {
        return PermissionUtils.getDeniedPermissions(context, permissions);
    }

    public static boolean isPermissionPermanentDenied(Activity activity, String permission) {
        return PermissionUtils.isPermissionPermanentDenied(activity, permission);
    }

    public static boolean isPermissionPermanentDenied(Activity activity, String[] permissions) {
        return XXPermissions.isPermissionPermanentDenied(activity, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isPermissionPermanentDenied(Activity activity, List<String> permissions) {
        return PermissionUtils.isPermissionPermanentDenied(activity, permissions);
    }

    public static boolean isSpecialPermission(String permission) {
        return PermissionUtils.isSpecialPermission(permission);
    }

    public static void startApplicationDetails(Context context) {
        FragmentActivity activity = PermissionUtils.findFragmentActivity(context);
        if (activity != null) {
            XXPermissions.startApplicationDetails((Activity)activity);
            return;
        }
        Intent intent = PermissionSettingPage.getApplicationDetailsIntent(context);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void startApplicationDetails(Activity activity) {
        activity.startActivityForResult(PermissionSettingPage.getApplicationDetailsIntent((Context)activity), 1025);
    }

    public static void startApplicationDetails(Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        fragment.startActivityForResult(PermissionSettingPage.getApplicationDetailsIntent((Context)activity), 1025);
    }

    public static void startPermissionActivity(Context context, String permission) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(permission));
    }

    public static void startPermissionActivity(Context context, String[] permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Context context, List<String> permissions) {
        FragmentActivity activity = PermissionUtils.findFragmentActivity(context);
        if (activity != null) {
            XXPermissions.startPermissionActivity((Activity)activity, permissions);
            return;
        }
        Intent intent = PermissionSettingPage.getSmartPermissionIntent(context, permissions);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void startPermissionActivity(Activity activity, String permission) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permission));
    }

    public static void startPermissionActivity(Activity activity, String[] permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Activity activity, List<String> permissions) {
        activity.startActivityForResult(PermissionSettingPage.getSmartPermissionIntent((Context)activity, permissions), 1025);
    }

    public static void startPermissionActivity(Fragment fragment, String permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Fragment fragment, String[] permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Fragment fragment, List<String> permissions) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        fragment.startActivityForResult(PermissionSettingPage.getSmartPermissionIntent((Context)activity, permissions), 1025);
    }
}

