/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.support.v4.app.FragmentActivity;
import com.hjq.permissions.ManifestRegisterException;
import com.hjq.permissions.Permission;
import com.hjq.permissions.XXPermissions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

final class PermissionUtils {
    private static final int PRIVATE_FLAG_REQUEST_LEGACY_EXTERNAL_STORAGE = 0x20000000;

    PermissionUtils() {
    }

    static boolean isAndroid11() {
        return Build.VERSION.SDK_INT >= 30;
    }

    static boolean isAndroid10() {
        return Build.VERSION.SDK_INT >= 29;
    }

    static boolean isAndroid9() {
        return Build.VERSION.SDK_INT >= 28;
    }

    static boolean isAndroid8() {
        return Build.VERSION.SDK_INT >= 26;
    }

    static boolean isAndroid7() {
        return Build.VERSION.SDK_INT >= 24;
    }

    static boolean isAndroid6() {
        return Build.VERSION.SDK_INT >= 23;
    }

    static List<String> getManifestPermissions(Context context) {
        try {
            String[] requestedPermissions = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
            return PermissionUtils.asArrayList(requestedPermissions);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    static boolean isGrantedStoragePermission(Context context) {
        if (PermissionUtils.isAndroid11()) {
            return Environment.isExternalStorageManager();
        }
        return XXPermissions.isGrantedPermission(context, Permission.Group.STORAGE);
    }

    static boolean isGrantedInstallPermission(Context context) {
        if (PermissionUtils.isAndroid8()) {
            return context.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    static boolean isGrantedWindowPermission(Context context) {
        if (PermissionUtils.isAndroid6()) {
            return Settings.canDrawOverlays((Context)context);
        }
        return true;
    }

    static boolean isGrantedNotifyPermission(Context context) {
        if (PermissionUtils.isAndroid7()) {
            return ((NotificationManager)context.getSystemService(NotificationManager.class)).areNotificationsEnabled();
        }
        if (PermissionUtils.isAndroid6()) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            try {
                Method method = appOps.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = appOps.getClass().getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)field.get(Integer.class);
                return (Integer)method.invoke((Object)appOps, value, context.getApplicationInfo().uid, context.getPackageName()) == 0;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }

    static boolean isGrantedSettingPermission(Context context) {
        if (PermissionUtils.isAndroid6()) {
            return Settings.System.canWrite((Context)context);
        }
        return true;
    }

    static boolean containsSpecialPermission(List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission : permissions) {
            if (!PermissionUtils.isSpecialPermission(permission)) continue;
            return true;
        }
        return false;
    }

    static boolean isSpecialPermission(String permission) {
        return "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission) || "android.permission.REQUEST_INSTALL_PACKAGES".equals(permission) || "android.permission.SYSTEM_ALERT_WINDOW".equals(permission) || "android.permission.NOTIFICATION_SERVICE".equals(permission) || "android.permission.WRITE_SETTINGS".equals(permission);
    }

    static boolean isGrantedPermissions(Context context, List<String> permissions) {
        if (!PermissionUtils.isAndroid6()) {
            return true;
        }
        for (String permission : permissions) {
            if (PermissionUtils.isGrantedPermission(context, permission)) continue;
            return false;
        }
        return true;
    }

    static List<String> getDeniedPermissions(Context context, List<String> permissions) {
        ArrayList<String> deniedPermission = new ArrayList<String>(permissions.size());
        if (!PermissionUtils.isAndroid6()) {
            return deniedPermission;
        }
        for (String permission : permissions) {
            if (PermissionUtils.isGrantedPermission(context, permission)) continue;
            deniedPermission.add(permission);
        }
        return deniedPermission;
    }

    static boolean isGrantedPermission(Context context, String permission) {
        if (!PermissionUtils.isAndroid6()) {
            return true;
        }
        if ("android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission)) {
            return PermissionUtils.isGrantedStoragePermission(context);
        }
        if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permission)) {
            return PermissionUtils.isGrantedInstallPermission(context);
        }
        if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permission)) {
            return PermissionUtils.isGrantedWindowPermission(context);
        }
        if ("android.permission.NOTIFICATION_SERVICE".equals(permission)) {
            return PermissionUtils.isGrantedNotifyPermission(context);
        }
        if ("android.permission.WRITE_SETTINGS".equals(permission)) {
            return PermissionUtils.isGrantedSettingPermission(context);
        }
        if (!PermissionUtils.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission)) {
                return true;
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission)) {
                return context.checkSelfPermission("android.permission.BODY_SENSORS") == 0;
            }
        }
        if (!PermissionUtils.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission)) {
            return true;
        }
        if (!PermissionUtils.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission)) {
                return true;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission)) {
                return context.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0;
            }
        }
        return context.checkSelfPermission(permission) == 0;
    }

    static int getPermissionStatus(Context context, String permission) {
        return PermissionUtils.isGrantedPermission(context, permission) ? 0 : -1;
    }

    static boolean isPermissionPermanentDenied(Activity activity, List<String> permissions) {
        for (String permission : permissions) {
            if (!PermissionUtils.isPermissionPermanentDenied(activity, permission)) continue;
            return true;
        }
        return false;
    }

    static boolean isPermissionPermanentDenied(Activity activity, String permission) {
        if (!PermissionUtils.isAndroid6()) {
            return false;
        }
        if (PermissionUtils.isSpecialPermission(permission)) {
            return false;
        }
        if (!PermissionUtils.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission)) {
                return false;
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission)) {
                return activity.checkSelfPermission("android.permission.BODY_SENSORS") == -1 && !activity.shouldShowRequestPermissionRationale(permission);
            }
        }
        if (!PermissionUtils.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission)) {
            return false;
        }
        if (!PermissionUtils.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission)) {
                return true;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission)) {
                return activity.checkSelfPermission("android.permission.READ_PHONE_STATE") == -1 && !activity.shouldShowRequestPermissionRationale(permission);
            }
        }
        return activity.checkSelfPermission(permission) == -1 && !activity.shouldShowRequestPermissionRationale(permission);
    }

    static List<String> getDeniedPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            deniedPermissions.add(permissions[i]);
        }
        return deniedPermissions;
    }

    static List<String> getGrantedPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            grantedPermissions.add(permissions[i]);
        }
        return grantedPermissions;
    }

    static void optimizeDeprecatedPermission(List<String> permission) {
        if (permission.contains("android.permission.MANAGE_EXTERNAL_STORAGE")) {
            if (permission.contains("android.permission.READ_EXTERNAL_STORAGE") || permission.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
                throw new IllegalArgumentException("Please do not apply for these two permissions dynamically");
            }
            if (!PermissionUtils.isAndroid11()) {
                permission.add("android.permission.READ_EXTERNAL_STORAGE");
                permission.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
        }
        if (!PermissionUtils.isAndroid8() && permission.contains("android.permission.READ_PHONE_NUMBERS") && !permission.contains("android.permission.READ_PHONE_STATE")) {
            permission.add("android.permission.READ_PHONE_STATE");
        }
        if (!PermissionUtils.isAndroid10() && permission.contains("android.permission.ACTIVITY_RECOGNITION") && !permission.contains("android.permission.BODY_SENSORS")) {
            permission.add("android.permission.BODY_SENSORS");
        }
    }

    static <T> ArrayList<T> asArrayList(T ... array) {
        if (array == null || array.length == 0) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    static void checkStoragePermission(Context context, List<String> requestPermissions) {
        int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        if (targetSdkVersion >= 29 && PermissionUtils.isAndroid10() && (requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") || requestPermissions.contains("android.permission.READ_EXTERNAL_STORAGE") || requestPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE"))) {
            try {
                boolean requestLegacyExternalStorage;
                Field field = ApplicationInfo.class.getDeclaredField("privateFlags");
                int privateFlags = (Integer)field.get(context.getApplicationInfo());
                boolean bl = requestLegacyExternalStorage = (privateFlags & 0x20000000) != 0;
                if (!requestLegacyExternalStorage) {
                    throw new IllegalStateException("Please register the android:requestLegacyExternalStorage=\"true\" attribute in the manifest file");
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (targetSdkVersion >= 30 && (requestPermissions.contains("android.permission.READ_EXTERNAL_STORAGE") || requestPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE"))) {
            throw new IllegalArgumentException("Please use Permission.MANAGE_EXTERNAL_STORAGE to request storage permission");
        }
    }

    static void checkLocationPermission(List<String> requestPermissions) {
        if (!requestPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            return;
        }
        for (String permission : requestPermissions) {
            if ("android.permission.ACCESS_FINE_LOCATION".equals(permission) || "android.permission.ACCESS_COARSE_LOCATION".equals(permission) || "android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission)) continue;
            throw new IllegalArgumentException("Because it includes background location permissions, do not apply for permissions unrelated to location");
        }
    }

    static void checkTargetSdkVersion(Context context, List<String> requestPermissions) {
        int targetSdkMinVersion = requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") ? 30 : (requestPermissions.contains("android.permission.ACCEPT_HANDOVER") ? 28 : (requestPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION") || requestPermissions.contains("android.permission.ACTIVITY_RECOGNITION") || requestPermissions.contains("android.permission.ACCESS_MEDIA_LOCATION") ? 29 : (requestPermissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") || requestPermissions.contains("android.permission.ANSWER_PHONE_CALLS") || requestPermissions.contains("android.permission.READ_PHONE_NUMBERS") ? 26 : 23)));
        if (context.getApplicationInfo().targetSdkVersion < targetSdkMinVersion) {
            throw new RuntimeException("The targetSdkVersion SDK must be " + targetSdkMinVersion + " or more");
        }
    }

    static void checkPermissionManifest(Context context, List<String> requestPermissions) {
        List<String> manifestPermissions = PermissionUtils.getManifestPermissions(context);
        if (manifestPermissions == null || manifestPermissions.isEmpty()) {
            throw new ManifestRegisterException();
        }
        int minSdkVersion = Build.VERSION.SDK_INT >= 24 ? context.getApplicationInfo().minSdkVersion : 23;
        for (String permission : requestPermissions) {
            if (minSdkVersion < 30 && "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission)) {
                if (!manifestPermissions.contains("android.permission.READ_EXTERNAL_STORAGE")) {
                    throw new ManifestRegisterException("android.permission.READ_EXTERNAL_STORAGE");
                }
                if (!manifestPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
                    throw new ManifestRegisterException("android.permission.WRITE_EXTERNAL_STORAGE");
                }
            }
            if (minSdkVersion < 29 && "android.permission.ACTIVITY_RECOGNITION".equals(permission) && !manifestPermissions.contains("android.permission.BODY_SENSORS")) {
                throw new ManifestRegisterException("android.permission.BODY_SENSORS");
            }
            if (minSdkVersion < 26 && "android.permission.READ_PHONE_NUMBERS".equals(permission) && !manifestPermissions.contains("android.permission.READ_PHONE_STATE")) {
                throw new ManifestRegisterException("android.permission.READ_PHONE_STATE");
            }
            if ("android.permission.NOTIFICATION_SERVICE".equals(permission) || manifestPermissions.contains(permission)) continue;
            throw new ManifestRegisterException(permission);
        }
    }

    static int getRandomRequestCode() {
        return new Random().nextInt((int)Math.pow(2.0, 8.0));
    }

    static FragmentActivity findFragmentActivity(Context context) {
        do {
            if (context instanceof FragmentActivity) {
                return (FragmentActivity)context;
            }
            if (!(context instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        } while (context != null);
        return null;
    }
}

