/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.PermissionFragment;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class XXPermissions {
    public static final int REQUEST_CODE = 1024;
    private static Boolean sDebugMode;
    private FragmentActivity mActivity;
    private List<String> mPermissions;

    public static XXPermissions with(FragmentActivity activity) {
        return new XXPermissions(activity);
    }

    public static XXPermissions with(Context context) {
        return XXPermissions.with(PermissionUtils.getFragmentActivity(context));
    }

    public static XXPermissions with(Fragment fragment) {
        return XXPermissions.with(fragment.getActivity());
    }

    public static void setDebugMode(boolean debug) {
        sDebugMode = debug;
    }

    private XXPermissions(FragmentActivity activity) {
        this.mActivity = activity;
    }

    public XXPermissions permission(String ... permissions) {
        if (this.mPermissions == null) {
            this.mPermissions = PermissionUtils.asArrayList(permissions);
        } else {
            this.mPermissions.addAll(PermissionUtils.asArrayList(permissions));
        }
        return this;
    }

    public XXPermissions permission(String[] ... permissions) {
        if (this.mPermissions == null) {
            int length = 0;
            String[][] stringArray = permissions;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] permission = stringArray[i];
                length += permission.length;
            }
            this.mPermissions = new ArrayList<String>(length);
        }
        for (String[] group : permissions) {
            this.mPermissions.addAll(PermissionUtils.asArrayList(group));
        }
        return this;
    }

    public XXPermissions permission(List<String> permissions) {
        if (this.mPermissions == null) {
            this.mPermissions = permissions;
        } else {
            this.mPermissions.addAll(permissions);
        }
        return this;
    }

    public void request(OnPermissionCallback callback) {
        if (this.mActivity == null || this.mActivity.isFinishing() || Build.VERSION.SDK_INT >= 17 && this.mActivity.isDestroyed()) {
            return;
        }
        if (this.mPermissions == null || this.mPermissions.isEmpty()) {
            throw new IllegalArgumentException("The requested permission cannot be empty");
        }
        if (sDebugMode == null) {
            sDebugMode = PermissionUtils.isDebugMode((Context)this.mActivity);
        }
        PermissionUtils.optimizeDeprecatedPermission(this.mPermissions);
        if (sDebugMode.booleanValue()) {
            PermissionUtils.checkTargetSdkVersion((Context)this.mActivity, this.mPermissions);
            PermissionUtils.checkPermissionManifest((Activity)this.mActivity, this.mPermissions);
        }
        if (PermissionUtils.isGrantedPermission((Context)this.mActivity, this.mPermissions)) {
            if (callback != null) {
                callback.onGranted(this.mPermissions, true);
            }
            return;
        }
        PermissionFragment.beginRequest(this.mActivity, new ArrayList<String>(this.mPermissions), callback);
    }

    public static boolean isGrantedPermission(Context context, String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return XXPermissions.isGrantedPermission(context, PermissionUtils.getManifestPermissions(context));
        }
        return XXPermissions.isGrantedPermission(context, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isGrantedPermission(Context context, List<String> permissions) {
        return PermissionUtils.isGrantedPermission(context, permissions);
    }

    public static boolean isGrantedPermission(Context context, String[] ... permissions) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : permissions) {
            permissionList.addAll(PermissionUtils.asArrayList(group));
        }
        return PermissionUtils.isGrantedPermission(context, permissionList);
    }

    public static void startApplicationDetails(Context context) {
        FragmentActivity activity = PermissionUtils.getFragmentActivity(context);
        if (activity != null) {
            XXPermissions.startApplicationDetails((Activity)activity);
            return;
        }
        Intent intent = PermissionSettingPage.getApplicationDetailsIntent(context);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void startApplicationDetails(Activity activity) {
        activity.startActivityForResult(PermissionSettingPage.getApplicationDetailsIntent((Context)activity), 1024);
    }

    public static void startApplicationDetails(Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        fragment.startActivityForResult(PermissionSettingPage.getApplicationDetailsIntent((Context)activity), 1024);
    }

    public static void startPermissionActivity(Context context, String ... permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Context context, List<String> permissions) {
        FragmentActivity activity = PermissionUtils.getFragmentActivity(context);
        if (activity != null) {
            XXPermissions.startPermissionActivity((Activity)activity, permissions);
            return;
        }
        Intent intent = PermissionSettingPage.getSmartPermissionIntent(context, permissions);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void startPermissionActivity(Activity activity, String ... permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Activity activity, List<String> permissions) {
        activity.startActivityForResult(PermissionSettingPage.getSmartPermissionIntent((Context)activity, permissions), 1024);
    }

    public static void startPermissionActivity(Fragment fragment, String ... permissions) {
        XXPermissions.startPermissionActivity(fragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(Fragment fragment, List<String> permissions) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        fragment.startActivityForResult(PermissionSettingPage.getSmartPermissionIntent((Context)activity, permissions), 1024);
    }
}

