/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.SparseBooleanArray;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class PermissionFragment
extends Fragment {
    private static final String PERMISSION_GROUP = "permission_group";
    private static final String REQUEST_CODE = "request_code";
    private static SparseBooleanArray sRequestCodes = new SparseBooleanArray();
    private boolean mSpecialRequest;
    private boolean mDangerousRequest;
    private OnPermissionCallback mCallBack;

    public static void beginRequest(FragmentActivity activity, ArrayList<String> permissions, OnPermissionCallback callback) {
        int requestCode;
        PermissionFragment fragment = new PermissionFragment();
        Bundle bundle = new Bundle();
        while (sRequestCodes.get(requestCode = PermissionUtils.getRandomRequestCode())) {
        }
        sRequestCodes.put(requestCode, true);
        bundle.putInt(REQUEST_CODE, requestCode);
        bundle.putStringArrayList(PERMISSION_GROUP, permissions);
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        fragment.setCallBack(callback);
        PermissionFragment.addFragment(activity.getSupportFragmentManager(), fragment);
    }

    public static void addFragment(FragmentManager manager, Fragment fragment) {
        if (manager == null) {
            return;
        }
        manager.beginTransaction().add(fragment, fragment.toString()).commitAllowingStateLoss();
    }

    public static void removeFragment(FragmentManager manager, Fragment fragment) {
        if (manager == null) {
            return;
        }
        manager.beginTransaction().remove(fragment).commitAllowingStateLoss();
    }

    public void setCallBack(OnPermissionCallback callback) {
        this.mCallBack = callback;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCallBack = null;
    }

    public void onResume() {
        super.onResume();
        if (this.mSpecialRequest) {
            return;
        }
        this.mSpecialRequest = true;
        if (this.mCallBack == null) {
            PermissionFragment.removeFragment(this.getFragmentManager(), this);
            return;
        }
        this.requestSpecialPermission();
    }

    public void requestDangerousPermission() {
        Bundle arguments = this.getArguments();
        if (arguments == null) {
            return;
        }
        final ArrayList allPermissions = arguments.getStringArrayList(PERMISSION_GROUP);
        if (allPermissions == null || allPermissions.size() == 0) {
            return;
        }
        ArrayList<String> locationPermission = null;
        if (PermissionUtils.isAndroid10() && allPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            locationPermission = new ArrayList<String>();
            if (allPermissions.contains("android.permission.ACCESS_COARSE_LOCATION") && !PermissionUtils.isGrantedPermission((Context)this.getActivity(), "android.permission.ACCESS_COARSE_LOCATION")) {
                locationPermission.add("android.permission.ACCESS_COARSE_LOCATION");
            }
            if (allPermissions.contains("android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.isGrantedPermission((Context)this.getActivity(), "android.permission.ACCESS_FINE_LOCATION")) {
                locationPermission.add("android.permission.ACCESS_FINE_LOCATION");
            }
        }
        if (locationPermission == null || locationPermission.isEmpty()) {
            this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), this.getArguments().getInt(REQUEST_CODE));
            return;
        }
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        PermissionFragment.beginRequest(activity, locationPermission, new OnPermissionCallback(){

            @Override
            public void onGranted(List<String> permissions, boolean all) {
                if (!all || !PermissionFragment.this.isAdded()) {
                    return;
                }
                Bundle arguments = PermissionFragment.this.getArguments();
                if (arguments == null) {
                    return;
                }
                PermissionFragment.this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), arguments.getInt(PermissionFragment.REQUEST_CODE));
            }

            @Override
            public void onDenied(List<String> permissions, boolean never) {
                if (!PermissionFragment.this.isAdded()) {
                    return;
                }
                Bundle arguments = PermissionFragment.this.getArguments();
                if (arguments == null) {
                    return;
                }
                PermissionFragment.this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), arguments.getInt(PermissionFragment.REQUEST_CODE));
            }
        });
    }

    public void requestSpecialPermission() {
        Bundle arguments = this.getArguments();
        if (arguments == null) {
            return;
        }
        ArrayList permissions = arguments.getStringArrayList(PERMISSION_GROUP);
        boolean requestSpecialPermission = false;
        if (PermissionUtils.containsSpecialPermission(permissions)) {
            if (permissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") && !PermissionUtils.isGrantedStoragePermission((Context)this.getActivity()) && PermissionUtils.isAndroid11()) {
                this.startActivityForResult(PermissionSettingPage.getStoragePermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") && !PermissionUtils.isGrantedInstallPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getInstallPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.SYSTEM_ALERT_WINDOW") && !PermissionUtils.isGrantedWindowPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getWindowPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.ACCESS_NOTIFICATION_POLICY") && !PermissionUtils.isGrantedNotifyPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getNotifyPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.WRITE_SETTINGS") && !PermissionUtils.isGrantedSettingPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getSettingPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
        }
        if (!requestSpecialPermission) {
            this.requestDangerousPermission();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Bundle arguments = this.getArguments();
        if (arguments == null) {
            return;
        }
        if (requestCode != arguments.getInt(REQUEST_CODE)) {
            return;
        }
        OnPermissionCallback callBack = this.mCallBack;
        this.mCallBack = null;
        if (callBack == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            if (PermissionUtils.isSpecialPermission(permission)) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)this.getActivity(), permission);
                continue;
            }
            if (PermissionUtils.isAndroid11() && "android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission)) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)this.getActivity(), permission);
                continue;
            }
            if (!PermissionUtils.isAndroid10() && ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) || "android.permission.ACTIVITY_RECOGNITION".equals(permission) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission))) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)this.getActivity(), permission);
                continue;
            }
            if (!PermissionUtils.isAndroid9() && "android.permission.ACCEPT_HANDOVER".equals(permission)) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)this.getActivity(), permission);
            }
            if (PermissionUtils.isAndroid8() || !"android.permission.ANSWER_PHONE_CALLS".equals(permission) && !"android.permission.READ_PHONE_NUMBERS".equals(permission)) continue;
            grantResults[i] = PermissionUtils.getPermissionStatus((Context)this.getActivity(), permission);
        }
        sRequestCodes.delete(requestCode);
        PermissionFragment.removeFragment(this.getFragmentManager(), this);
        List<String> grantedPermission = PermissionUtils.getGrantedPermissions(permissions, grantResults);
        if (grantedPermission.size() == permissions.length) {
            callBack.onGranted(grantedPermission, true);
            return;
        }
        List<String> deniedPermission = PermissionUtils.getDeniedPermissions(permissions, grantResults);
        callBack.onDenied(deniedPermission, PermissionUtils.isPermissionPermanentDenied((Activity)this.getActivity(), deniedPermission));
        if (!grantedPermission.isEmpty()) {
            callBack.onGranted(grantedPermission, false);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Bundle arguments = this.getArguments();
        if (arguments == null) {
            return;
        }
        if (!this.mDangerousRequest && requestCode == arguments.getInt(REQUEST_CODE)) {
            this.mDangerousRequest = true;
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!PermissionFragment.this.isAdded()) {
                        return;
                    }
                    PermissionFragment.this.requestDangerousPermission();
                }
            }, 300L);
        }
    }
}

