/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.hjq.permissions.OnPermission;
import com.hjq.permissions.PermissionFragment;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class XXPermissions {
    public static final int REQUEST_CODE = 1024;
    private static Boolean sDebugMode;
    private Activity mActivity;
    private List<String> mPermissions;

    private XXPermissions(Activity activity) {
        this.mActivity = activity;
    }

    public static XXPermissions with(Context context) {
        return XXPermissions.with(PermissionUtils.getActivity(context));
    }

    public static XXPermissions with(Activity activity) {
        return new XXPermissions(activity);
    }

    public static void setDebugMode(boolean debug) {
        sDebugMode = debug;
    }

    public XXPermissions permission(String ... permissions) {
        if (this.mPermissions == null) {
            this.mPermissions = PermissionUtils.asArrayList(permissions);
        } else {
            this.mPermissions.addAll(PermissionUtils.asArrayList(permissions));
        }
        return this;
    }

    public XXPermissions permission(String[] ... permissions) {
        if (this.mPermissions == null) {
            int length = 0;
            String[][] stringArray = permissions;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] permission = stringArray[i];
                length += permission.length;
            }
            this.mPermissions = new ArrayList<String>(length);
        }
        for (String[] group : permissions) {
            this.mPermissions.addAll(PermissionUtils.asArrayList(group));
        }
        return this;
    }

    public XXPermissions permission(List<String> permissions) {
        if (this.mPermissions == null) {
            this.mPermissions = permissions;
        } else {
            this.mPermissions.addAll(permissions);
        }
        return this;
    }

    public void request(OnPermission callback) {
        if (this.mActivity == null || this.mActivity.isFinishing() || Build.VERSION.SDK_INT >= 17 && this.mActivity.isDestroyed()) {
            return;
        }
        if (this.mPermissions == null || this.mPermissions.isEmpty()) {
            throw new IllegalArgumentException("The requested permission cannot be empty");
        }
        if (sDebugMode == null) {
            sDebugMode = PermissionUtils.isDebugMode((Context)this.mActivity);
        }
        PermissionUtils.optimizeDeprecatedPermission(this.mPermissions);
        if (sDebugMode.booleanValue()) {
            PermissionUtils.checkTargetSdkVersion((Context)this.mActivity, this.mPermissions);
            PermissionUtils.checkPermissionManifest(this.mActivity, this.mPermissions);
        }
        if (PermissionUtils.isPermissionGranted((Context)this.mActivity, this.mPermissions)) {
            if (callback != null) {
                callback.hasPermission(this.mPermissions, true);
            }
            return;
        }
        PermissionFragment.beginRequest(this.mActivity, new ArrayList<String>(this.mPermissions), callback);
    }

    public static boolean hasPermission(Context context, String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return XXPermissions.hasPermission(context, PermissionUtils.getManifestPermissions(context));
        }
        return XXPermissions.hasPermission(context, PermissionUtils.asArrayList(permissions));
    }

    public static boolean hasPermission(Context context, List<String> permissions) {
        return PermissionUtils.isPermissionGranted(context, permissions);
    }

    public static boolean hasPermission(Context context, String[] ... permissions) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : permissions) {
            permissionList.addAll(PermissionUtils.asArrayList(group));
        }
        return PermissionUtils.isPermissionGranted(context, permissionList);
    }

    public static void startPermissionActivity(Context context) {
        XXPermissions.startApplicationDetails(context);
    }

    public static void startApplicationDetails(Context context) {
        Activity activity = PermissionUtils.getActivity(context);
        if (activity != null) {
            XXPermissions.startApplicationDetails(activity);
            return;
        }
        Intent intent = PermissionSettingPage.getApplicationDetailsIntent(context);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void startApplicationDetails(Activity activity) {
        activity.startActivityForResult(PermissionSettingPage.getApplicationDetailsIntent((Context)activity), 1024);
    }

    public static void startPermissionActivity(Context context, String ... deniedPermissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(deniedPermissions));
    }

    public static void startPermissionActivity(Context context, List<String> deniedPermissions) {
        Activity activity = PermissionUtils.getActivity(context);
        if (activity != null) {
            XXPermissions.startPermissionActivity(activity, deniedPermissions);
            return;
        }
        Intent intent = PermissionSettingPage.getSmartPermissionIntent(context, deniedPermissions);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void startPermissionActivity(Activity activity, String ... deniedPermission) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(deniedPermission));
    }

    public static void startPermissionActivity(Activity activity, List<String> deniedPermissions) {
        activity.startActivityForResult(PermissionSettingPage.getSmartPermissionIntent((Context)activity, deniedPermissions), 1024);
    }
}

