/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import com.hjq.permissions.ManifestException;
import com.hjq.permissions.Permission;
import com.hjq.permissions.XXPermissions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

final class PermissionUtils {
    PermissionUtils() {
    }

    static boolean isAndroid6() {
        return Build.VERSION.SDK_INT >= 23;
    }

    static boolean isAndroid7() {
        return Build.VERSION.SDK_INT >= 24;
    }

    static boolean isAndroid8() {
        return Build.VERSION.SDK_INT >= 26;
    }

    static boolean isAndroid10() {
        return Build.VERSION.SDK_INT >= 29;
    }

    static boolean isAndroid11() {
        return Build.VERSION.SDK_INT >= 30;
    }

    static List<String> getManifestPermissions(Context context) {
        try {
            String[] requestedPermissions = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
            if (requestedPermissions != null) {
                return PermissionUtils.asArrayList(requestedPermissions);
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return null;
        }
    }

    static boolean hasStoragePermission(Context context) {
        if (PermissionUtils.isAndroid11()) {
            return Environment.isExternalStorageManager();
        }
        return XXPermissions.hasPermission(context, Permission.Group.STORAGE);
    }

    static boolean hasInstallPermission(Context context) {
        if (PermissionUtils.isAndroid8()) {
            return context.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    static boolean hasWindowPermission(Context context) {
        if (PermissionUtils.isAndroid6()) {
            return Settings.canDrawOverlays((Context)context);
        }
        return true;
    }

    static boolean hasNotifyPermission(Context context) {
        if (PermissionUtils.isAndroid7()) {
            return ((NotificationManager)context.getSystemService(NotificationManager.class)).areNotificationsEnabled();
        }
        if (PermissionUtils.isAndroid6()) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            try {
                Method method = appOps.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = appOps.getClass().getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)field.get(Integer.class);
                return (Integer)method.invoke((Object)appOps, value, context.getApplicationInfo().uid, context.getPackageName()) == 0;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException ignored) {
                return true;
            }
        }
        return true;
    }

    static boolean hasSettingPermission(Context context) {
        if (PermissionUtils.isAndroid6()) {
            return Settings.System.canWrite((Context)context);
        }
        return true;
    }

    static boolean containsSpecialPermission(List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission : permissions) {
            if (!PermissionUtils.isSpecialPermission(permission)) continue;
            return true;
        }
        return false;
    }

    static boolean isSpecialPermission(String permission) {
        return "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission) || "android.permission.REQUEST_INSTALL_PACKAGES".equals(permission) || "android.permission.SYSTEM_ALERT_WINDOW".equals(permission) || "android.permission.ACCESS_NOTIFICATION_POLICY".equals(permission) || "android.permission.WRITE_SETTINGS".equals(permission);
    }

    static boolean isPermissionGranted(Context context, List<String> permissions) {
        if (!PermissionUtils.isAndroid6()) {
            return true;
        }
        for (String permission : permissions) {
            if (PermissionUtils.isPermissionGranted(context, permission)) continue;
            return false;
        }
        return true;
    }

    static boolean isPermissionGranted(Context context, String permission) {
        if (!PermissionUtils.isAndroid6()) {
            return true;
        }
        if ("android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission)) {
            return PermissionUtils.hasStoragePermission(context);
        }
        if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permission)) {
            return PermissionUtils.hasInstallPermission(context);
        }
        if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permission)) {
            return PermissionUtils.hasWindowPermission(context);
        }
        if ("android.permission.ACCESS_NOTIFICATION_POLICY".equals(permission)) {
            return PermissionUtils.hasNotifyPermission(context);
        }
        if ("android.permission.WRITE_SETTINGS".equals(permission)) {
            return PermissionUtils.hasSettingPermission(context);
        }
        if (!PermissionUtils.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission)) {
                return true;
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission)) {
                return context.checkSelfPermission("android.permission.BODY_SENSORS") == 0;
            }
        }
        if (!PermissionUtils.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission)) {
                return context.checkSelfPermission("android.permission.PROCESS_OUTGOING_CALLS") == 0;
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission)) {
                return context.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0;
            }
        }
        return context.checkSelfPermission(permission) == 0;
    }

    static int getPermissionStatus(Context context, String permission) {
        return PermissionUtils.isPermissionGranted(context, permission) ? 0 : -1;
    }

    static boolean isPermissionPermanentDenied(Activity activity, List<String> permissions) {
        for (String permission : permissions) {
            if (!PermissionUtils.isPermissionPermanentDenied(activity, permission)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPermissionPermanentDenied(Activity activity, String permission) {
        if (!PermissionUtils.isAndroid6()) {
            return false;
        }
        if (PermissionUtils.isSpecialPermission(permission)) {
            return false;
        }
        if (!PermissionUtils.isAndroid10()) {
            if ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission)) {
                return false;
            }
            if ("android.permission.ACTIVITY_RECOGNITION".equals(permission)) {
                return activity.checkSelfPermission("android.permission.BODY_SENSORS") == -1 && !activity.shouldShowRequestPermissionRationale(permission);
            }
        }
        if (!PermissionUtils.isAndroid8()) {
            if ("android.permission.ANSWER_PHONE_CALLS".equals(permission)) {
                return activity.checkSelfPermission("android.permission.PROCESS_OUTGOING_CALLS") == -1 && !activity.shouldShowRequestPermissionRationale(permission);
            }
            if ("android.permission.READ_PHONE_NUMBERS".equals(permission)) {
                return activity.checkSelfPermission("android.permission.READ_PHONE_STATE") == -1 && !activity.shouldShowRequestPermissionRationale(permission);
            }
        }
        return activity.checkSelfPermission(permission) == -1 && !activity.shouldShowRequestPermissionRationale(permission);
    }

    static List<String> getDeniedPermission(String[] permissions, int[] grantResults) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            deniedPermissions.add(permissions[i]);
        }
        return deniedPermissions;
    }

    static List<String> getGrantedPermission(String[] permissions, int[] grantResults) {
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            grantedPermissions.add(permissions[i]);
        }
        return grantedPermissions;
    }

    static void optimizeDeprecatedPermission(List<String> permission) {
        if (permission.contains("android.permission.MANAGE_EXTERNAL_STORAGE")) {
            if (permission.contains("android.permission.READ_EXTERNAL_STORAGE") || permission.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
                throw new IllegalArgumentException("Please do not apply for these two permissions dynamically");
            }
            if (!PermissionUtils.isAndroid11()) {
                permission.add("android.permission.READ_EXTERNAL_STORAGE");
                permission.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
        }
        if (permission.contains("android.permission.ANSWER_PHONE_CALLS")) {
            if (permission.contains("android.permission.PROCESS_OUTGOING_CALLS")) {
                throw new IllegalArgumentException("Please do not apply for these two permissions dynamically");
            }
            if (!PermissionUtils.isAndroid10() && !permission.contains("android.permission.PROCESS_OUTGOING_CALLS")) {
                permission.add("android.permission.PROCESS_OUTGOING_CALLS");
            }
        }
        if (permission.contains("android.permission.ACTIVITY_RECOGNITION") && !PermissionUtils.isAndroid10() && !permission.contains("android.permission.BODY_SENSORS")) {
            permission.add("android.permission.BODY_SENSORS");
        }
    }

    static boolean hasActivityIntent(Context context, Intent intent) {
        return !context.getPackageManager().queryIntentActivities(intent, 65536).isEmpty();
    }

    static boolean isDebugMode(Context context) {
        return context.getApplicationInfo() != null && (context.getApplicationInfo().flags & 2) != 0;
    }

    static <T> ArrayList<T> asArrayList(T ... array) {
        ArrayList<T> list = null;
        if (array != null) {
            list = new ArrayList<T>(array.length);
            for (T t : array) {
                list.add(t);
            }
        }
        return list;
    }

    static void checkPermissionManifest(Activity activity, List<String> requestPermissions) {
        List<String> manifestPermissions = PermissionUtils.getManifestPermissions((Context)activity);
        if (manifestPermissions == null || manifestPermissions.isEmpty()) {
            throw new ManifestException();
        }
        int minSdkVersion = Build.VERSION.SDK_INT >= 24 ? activity.getApplicationInfo().minSdkVersion : 23;
        for (String permission : requestPermissions) {
            if (minSdkVersion < 30 && "android.permission.MANAGE_EXTERNAL_STORAGE".equals(permission)) {
                if (!manifestPermissions.contains("android.permission.READ_EXTERNAL_STORAGE")) {
                    throw new ManifestException("android.permission.READ_EXTERNAL_STORAGE");
                }
                if (!manifestPermissions.contains("android.permission.WRITE_EXTERNAL_STORAGE")) {
                    throw new ManifestException("android.permission.WRITE_EXTERNAL_STORAGE");
                }
            }
            if (minSdkVersion < 29 && "android.permission.ACTIVITY_RECOGNITION".equals(permission) && !manifestPermissions.contains("android.permission.BODY_SENSORS")) {
                throw new ManifestException("android.permission.BODY_SENSORS");
            }
            if (minSdkVersion < 26) {
                if ("android.permission.ANSWER_PHONE_CALLS".equals(permission) && !manifestPermissions.contains("android.permission.PROCESS_OUTGOING_CALLS")) {
                    throw new ManifestException("android.permission.PROCESS_OUTGOING_CALLS");
                }
                if ("android.permission.READ_PHONE_NUMBERS".equals(permission) && !manifestPermissions.contains("android.permission.READ_PHONE_STATE")) {
                    throw new ManifestException("android.permission.READ_PHONE_STATE");
                }
            }
            if ("android.permission.ACCESS_NOTIFICATION_POLICY".equals(permission) || manifestPermissions.contains(permission)) continue;
            throw new ManifestException(permission);
        }
    }

    static void checkTargetSdkVersion(Context context, List<String> requestPermissions) {
        int targetSdkMinVersion = requestPermissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") ? 30 : (requestPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION") || requestPermissions.contains("android.permission.ACTIVITY_RECOGNITION") || requestPermissions.contains("android.permission.ACCESS_MEDIA_LOCATION") ? 29 : (requestPermissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") || requestPermissions.contains("android.permission.ANSWER_PHONE_CALLS") || requestPermissions.contains("android.permission.READ_PHONE_NUMBERS") ? 26 : 23));
        if (context.getApplicationInfo().targetSdkVersion < targetSdkMinVersion) {
            throw new RuntimeException("The targetSdkVersion SDK must be " + targetSdkMinVersion + " or more");
        }
    }

    static int getRandomRequestCode() {
        return new Random().nextInt((int)Math.pow(2.0, 16.0));
    }

    static Activity getActivity(Context context) {
        do {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            if (!(context instanceof ContextWrapper)) {
                return null;
            }
            context = ((ContextWrapper)context).getBaseContext();
        } while (context != null);
        return null;
    }
}

