/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.SparseBooleanArray;
import com.hjq.permissions.OnPermission;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ValidFragment"})
@TargetApi(value=23)
public final class PermissionFragment
extends Fragment {
    private static final String PERMISSION_GROUP = "permission_group";
    private static final String REQUEST_CODE = "request_code";
    private static SparseBooleanArray sRequestCodes = new SparseBooleanArray();
    private boolean mSpecialRequest;
    private boolean mDangerousRequest;
    private OnPermission mCallBack;

    public static void beginRequest(Activity activity, ArrayList<String> permissions, OnPermission callback) {
        int requestCode;
        PermissionFragment fragment = new PermissionFragment(callback);
        Bundle bundle = new Bundle();
        while (sRequestCodes.get(requestCode = PermissionUtils.getRandomRequestCode())) {
        }
        sRequestCodes.put(requestCode, true);
        bundle.putInt(REQUEST_CODE, requestCode);
        bundle.putStringArrayList(PERMISSION_GROUP, permissions);
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        PermissionFragment.addFragment(activity.getFragmentManager(), fragment);
    }

    public static void addFragment(FragmentManager manager, Fragment fragment) {
        manager.beginTransaction().add(fragment, fragment.toString()).commitAllowingStateLoss();
    }

    public static void removeFragment(FragmentManager manager, Fragment fragment) {
        manager.beginTransaction().remove(fragment).commitAllowingStateLoss();
    }

    public PermissionFragment() {
    }

    public PermissionFragment(OnPermission callback) {
        this.mCallBack = callback;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCallBack = null;
    }

    public void onResume() {
        super.onResume();
        if (this.mSpecialRequest) {
            return;
        }
        this.mSpecialRequest = true;
        if (this.mCallBack == null) {
            PermissionFragment.removeFragment(this.getFragmentManager(), this);
            return;
        }
        this.requestSpecialPermission();
    }

    public void requestDangerousPermission() {
        final ArrayList allPermissions = this.getArguments().getStringArrayList(PERMISSION_GROUP);
        if (allPermissions == null || allPermissions.size() == 0) {
            return;
        }
        ArrayList<String> locationPermission = null;
        if (PermissionUtils.isAndroid11() && allPermissions.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            locationPermission = new ArrayList<String>();
            if (allPermissions.contains("android.permission.ACCESS_COARSE_LOCATION") && !PermissionUtils.isPermissionGranted((Context)this.getActivity(), "android.permission.ACCESS_COARSE_LOCATION")) {
                locationPermission.add("android.permission.ACCESS_COARSE_LOCATION");
            }
            if (allPermissions.contains("android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.isPermissionGranted((Context)this.getActivity(), "android.permission.ACCESS_FINE_LOCATION")) {
                locationPermission.add("android.permission.ACCESS_FINE_LOCATION");
            }
        }
        if (locationPermission == null || locationPermission.isEmpty()) {
            this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), this.getArguments().getInt(REQUEST_CODE));
            return;
        }
        PermissionFragment.beginRequest(this.getActivity(), locationPermission, new OnPermission(){

            @Override
            public void hasPermission(List<String> granted, boolean all) {
                if (all && PermissionFragment.this.isAdded()) {
                    PermissionFragment.this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), PermissionFragment.this.getArguments().getInt(PermissionFragment.REQUEST_CODE));
                }
            }

            @Override
            public void noPermission(List<String> denied, boolean never) {
                PermissionFragment.this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), PermissionFragment.this.getArguments().getInt(PermissionFragment.REQUEST_CODE));
            }
        });
    }

    public void requestSpecialPermission() {
        ArrayList permissions = this.getArguments().getStringArrayList(PERMISSION_GROUP);
        boolean requestSpecialPermission = false;
        if (PermissionUtils.containsSpecialPermission(permissions)) {
            if (permissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") && !PermissionUtils.hasStoragePermission((Context)this.getActivity()) && PermissionUtils.isAndroid11()) {
                this.startActivityForResult(PermissionSettingPage.getStoragePermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") && !PermissionUtils.hasInstallPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getInstallPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.SYSTEM_ALERT_WINDOW") && !PermissionUtils.hasWindowPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getWindowPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.ACCESS_NOTIFICATION_POLICY") && !PermissionUtils.hasNotifyPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getNotifyPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.WRITE_SETTINGS") && !PermissionUtils.hasSettingPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getSettingPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
        }
        if (!requestSpecialPermission) {
            this.requestDangerousPermission();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode != this.getArguments().getInt(REQUEST_CODE)) {
            return;
        }
        OnPermission callBack = this.mCallBack;
        this.mCallBack = null;
        if (callBack == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            if (PermissionUtils.isSpecialPermission(permission)) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)this.getActivity(), permission);
                continue;
            }
            if (PermissionUtils.isAndroid11() && "android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission)) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)this.getActivity(), permission);
                continue;
            }
            if (!PermissionUtils.isAndroid10() && ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) || "android.permission.ACTIVITY_RECOGNITION".equals(permission) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission))) {
                grantResults[i] = PermissionUtils.getPermissionStatus((Context)this.getActivity(), permission);
                continue;
            }
            if (PermissionUtils.isAndroid8() || !"android.permission.ANSWER_PHONE_CALLS".equals(permission) && !"android.permission.READ_PHONE_NUMBERS".equals(permission)) continue;
            grantResults[i] = PermissionUtils.getPermissionStatus((Context)this.getActivity(), permission);
        }
        sRequestCodes.delete(requestCode);
        PermissionFragment.removeFragment(this.getFragmentManager(), this);
        List<String> grantedPermission = PermissionUtils.getGrantedPermission(permissions, grantResults);
        if (grantedPermission.size() == permissions.length) {
            callBack.hasPermission(grantedPermission, true);
            return;
        }
        List<String> deniedPermission = PermissionUtils.getDeniedPermission(permissions, grantResults);
        callBack.noPermission(deniedPermission, PermissionUtils.isPermissionPermanentDenied(this.getActivity(), deniedPermission));
        if (!grantedPermission.isEmpty()) {
            callBack.hasPermission(grantedPermission, false);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (!this.mDangerousRequest && requestCode == this.getArguments().getInt(REQUEST_CODE)) {
            this.mDangerousRequest = true;
            this.getActivity().getWindow().getDecorView().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (PermissionFragment.this.isAdded()) {
                        PermissionFragment.this.requestDangerousPermission();
                    }
                }
            }, 300L);
        }
    }
}

