/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import com.hjq.permissions.OnPermission;
import com.hjq.permissions.PermissionFragment;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class XXPermissions {
    private static Boolean sDebugMode;
    private Activity mActivity;
    private List<String> mPermissions;

    private XXPermissions(Activity activity) {
        this.mActivity = activity;
    }

    public static XXPermissions with(Activity activity) {
        return new XXPermissions(activity);
    }

    public static void setDebugMode(boolean debug) {
        sDebugMode = debug;
    }

    public XXPermissions permission(String ... permissions) {
        if (this.mPermissions == null) {
            this.mPermissions = PermissionUtils.asArrayList(permissions);
        } else {
            this.mPermissions.addAll(PermissionUtils.asArrayList(permissions));
        }
        return this;
    }

    public XXPermissions permission(String[] ... permissions) {
        if (this.mPermissions == null) {
            int length = 0;
            String[][] stringArray = permissions;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] permission = stringArray[i];
                length += permission.length;
            }
            this.mPermissions = new ArrayList<String>(length);
        }
        for (String[] group : permissions) {
            this.mPermissions.addAll(PermissionUtils.asArrayList(group));
        }
        return this;
    }

    public XXPermissions permission(List<String> permissions) {
        if (this.mPermissions == null) {
            this.mPermissions = permissions;
        } else {
            this.mPermissions.addAll(permissions);
        }
        return this;
    }

    public void request(OnPermission callback) {
        if (callback == null) {
            throw new IllegalArgumentException("The permission request callback interface must be implemented");
        }
        if (this.mPermissions == null || this.mPermissions.isEmpty()) {
            throw new IllegalArgumentException("The requested permission cannot be empty");
        }
        if (this.mActivity == null) {
            throw new IllegalArgumentException("The activity is empty");
        }
        if (Build.VERSION.SDK_INT >= 17 && this.mActivity.isDestroyed()) {
            throw new IllegalStateException("The activity has been destroyed");
        }
        if (sDebugMode == null) {
            sDebugMode = PermissionUtils.isDebugMode((Context)this.mActivity);
        }
        PermissionUtils.optimizePermission(this.mPermissions);
        if (sDebugMode.booleanValue()) {
            PermissionUtils.checkTargetSdkVersion((Context)this.mActivity, this.mPermissions);
        }
        if (PermissionUtils.isPermissionGranted((Context)this.mActivity, this.mPermissions)) {
            callback.hasPermission(this.mPermissions, true);
        } else {
            if (sDebugMode.booleanValue()) {
                PermissionUtils.checkPermissionManifest(this.mActivity, this.mPermissions);
            }
            PermissionFragment.newInstance(new ArrayList<String>(this.mPermissions)).prepareRequest(this.mActivity, callback);
        }
    }

    public static boolean hasPermission(Context context, String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            return XXPermissions.hasPermission(context, PermissionUtils.getManifestPermissions(context));
        }
        return XXPermissions.hasPermission(context, PermissionUtils.asArrayList(permissions));
    }

    public static boolean hasPermission(Context context, List<String> permissions) {
        return PermissionUtils.isPermissionGranted(context, permissions);
    }

    public static boolean hasPermission(Context context, String[] ... permissions) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : permissions) {
            permissionList.addAll(PermissionUtils.asArrayList(group));
        }
        return PermissionUtils.isPermissionGranted(context, permissionList);
    }

    public static void startPermissionActivity(Context context) {
        XXPermissions.startApplicationDetails(context);
    }

    public static void startApplicationDetails(Context context) {
        context.startActivity(PermissionSettingPage.getApplicationDetailsIntent(context));
    }

    public static int startApplicationDetails(Activity activity) {
        int requestCode = PermissionUtils.getRandomRequestCode();
        activity.startActivityForResult(PermissionSettingPage.getApplicationDetailsIntent((Context)activity), requestCode);
        return requestCode;
    }

    public static void startPermissionActivity(Context context, List<String> deniedPermissions) {
        try {
            context.startActivity(PermissionSettingPage.getSmartPermissionIntent(context, deniedPermissions));
        }
        catch (Exception ignored) {
            context.startActivity(PermissionSettingPage.getApplicationDetailsIntent(context));
        }
    }

    public static int startPermissionActivity(Activity activity, List<String> deniedPermissions) {
        int requestCode = PermissionUtils.getRandomRequestCode();
        try {
            activity.startActivityForResult(PermissionSettingPage.getSmartPermissionIntent((Context)activity, deniedPermissions), requestCode);
        }
        catch (Exception ignored) {
            activity.startActivityForResult(PermissionSettingPage.getApplicationDetailsIntent((Context)activity), requestCode);
        }
        return requestCode;
    }
}

