/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import com.hjq.permissions.OnPermission;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=23)
public final class PermissionFragment
extends Fragment {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private static final String PERMISSION_GROUP = "permission_group";
    private static final String REQUEST_CODE = "request_code";
    private static SparseArray<SoftReference<OnPermission>> sCallbacks = new SparseArray();
    private boolean mSpecialRequest;
    private boolean mDangerousRequest;

    public static PermissionFragment newInstance(ArrayList<String> permissions) {
        int requestCode;
        PermissionFragment fragment = new PermissionFragment();
        fragment.setRetainInstance(true);
        Bundle bundle = new Bundle();
        while (sCallbacks.get(requestCode = PermissionUtils.getRandomRequestCode()) != null) {
        }
        bundle.putInt(REQUEST_CODE, requestCode);
        bundle.putStringArrayList(PERMISSION_GROUP, permissions);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void prepareRequest(Activity activity, OnPermission callback) {
        sCallbacks.put(this.getArguments().getInt(REQUEST_CODE), new SoftReference<OnPermission>(callback));
        activity.getFragmentManager().beginTransaction().add((Fragment)this, activity.getClass().getName()).commitAllowingStateLoss();
    }

    public void onResume() {
        super.onResume();
        if (!this.mSpecialRequest) {
            this.mSpecialRequest = true;
            this.requestSpecialPermission();
        }
    }

    public void requestDangerousPermission() {
        ArrayList permissions = this.getArguments().getStringArrayList(PERMISSION_GROUP);
        if (permissions != null && permissions.size() > 0) {
            this.requestPermissions(permissions.toArray(new String[permissions.size() - 1]), this.getArguments().getInt(REQUEST_CODE));
        }
    }

    public void requestSpecialPermission() {
        ArrayList permissions = this.getArguments().getStringArrayList(PERMISSION_GROUP);
        boolean requestSpecialPermission = false;
        if (PermissionUtils.containsSpecialPermission(permissions)) {
            if (permissions.contains("android.permission.MANAGE_EXTERNAL_STORAGE") && !PermissionUtils.hasStoragePermission((Context)this.getActivity()) && PermissionUtils.isAndroid11()) {
                this.startActivityForResult(PermissionSettingPage.getStoragePermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") && !PermissionUtils.hasInstallPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getInstallPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.SYSTEM_ALERT_WINDOW") && !PermissionUtils.hasWindowPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getWindowPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.ACCESS_NOTIFICATION_POLICY") && !PermissionUtils.hasNotifyPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getNotifyPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
            if (permissions.contains("android.permission.WRITE_SETTINGS") && !PermissionUtils.hasSettingPermission((Context)this.getActivity())) {
                this.startActivityForResult(PermissionSettingPage.getSettingPermissionIntent((Context)this.getActivity()), this.getArguments().getInt(REQUEST_CODE));
                requestSpecialPermission = true;
            }
        }
        if (!requestSpecialPermission) {
            this.requestDangerousPermission();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        SoftReference reference = (SoftReference)sCallbacks.get(requestCode);
        if (reference == null) {
            return;
        }
        OnPermission callback = (OnPermission)reference.get();
        if (callback == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            String permission = permissions[i];
            if (PermissionUtils.isSpecialPermission(permission)) {
                grantResults[i] = PermissionUtils.isPermissionGranted((Context)this.getActivity(), permission) ? 0 : -1;
                continue;
            }
            if (!PermissionUtils.isAndroid10() && ("android.permission.ACCESS_BACKGROUND_LOCATION".equals(permission) || "android.permission.ACTIVITY_RECOGNITION".equals(permission) || "android.permission.ACCESS_MEDIA_LOCATION".equals(permission))) {
                int n = grantResults[i] = PermissionUtils.isPermissionGranted((Context)this.getActivity(), permission) ? 0 : -1;
            }
            if (PermissionUtils.isAndroid8() || !"android.permission.ANSWER_PHONE_CALLS".equals(permission) && !"android.permission.READ_PHONE_NUMBERS".equals(permission)) continue;
            grantResults[i] = PermissionUtils.isPermissionGranted((Context)this.getActivity(), permission) ? 0 : -1;
        }
        List<String> succeedPermissions = PermissionUtils.getGrantedPermission(permissions, grantResults);
        if (succeedPermissions.size() == permissions.length) {
            callback.hasPermission(succeedPermissions, true);
        } else {
            List<String> failPermissions = PermissionUtils.getDeniedPermission(permissions, grantResults);
            callback.noPermission(failPermissions, PermissionUtils.isPermissionPermanentDenied(this.getActivity(), failPermissions));
            if (!succeedPermissions.isEmpty()) {
                callback.hasPermission(succeedPermissions, false);
            }
        }
        sCallbacks.remove(requestCode);
        this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (!this.mDangerousRequest && requestCode == this.getArguments().getInt(REQUEST_CODE)) {
            this.mDangerousRequest = true;
            HANDLER.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (PermissionFragment.this.isAdded()) {
                        PermissionFragment.this.requestDangerousPermission();
                    }
                }
            }, 500L);
        }
    }
}

