/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import com.hjq.permissions.OnPermission;
import com.hjq.permissions.PermissionUtils;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class PermissionFragment
extends Fragment
implements Runnable {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private static final String PERMISSION_GROUP = "permission_group";
    private static final String REQUEST_CODE = "request_code";
    private static final String REQUEST_CONSTANT = "request_constant";
    private static final SparseArray<SoftReference<OnPermission>> CALLBACKS = new SparseArray();
    private boolean mCallback;

    public static PermissionFragment newInstance(ArrayList<String> permissions, boolean constant) {
        int requestCode;
        PermissionFragment fragment = new PermissionFragment();
        Bundle bundle = new Bundle();
        while (CALLBACKS.get(requestCode = new Random().nextInt(255)) != null) {
        }
        bundle.putInt(REQUEST_CODE, requestCode);
        bundle.putStringArrayList(PERMISSION_GROUP, permissions);
        bundle.putBoolean(REQUEST_CONSTANT, constant);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void prepareRequest(Activity activity, OnPermission callback) {
        CALLBACKS.put(this.getArguments().getInt(REQUEST_CODE), new SoftReference<OnPermission>(callback));
        activity.getFragmentManager().beginTransaction().add((Fragment)this, activity.getClass().getName()).commitAllowingStateLoss();
    }

    @SuppressLint(value={"InlinedApi"})
    public void onActivityCreated(Bundle savedInstanceState) {
        Intent intent;
        super.onActivityCreated(savedInstanceState);
        ArrayList permissions = this.getArguments().getStringArrayList(PERMISSION_GROUP);
        if (permissions == null) {
            return;
        }
        boolean isRequestPermission = false;
        if (permissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") && !PermissionUtils.isHasInstallPermission((Context)this.getActivity())) {
            intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES", Uri.parse((String)("package:" + this.getContext().getPackageName())));
            this.startActivityForResult(intent, this.getArguments().getInt(REQUEST_CODE));
            isRequestPermission = true;
        }
        if (permissions.contains("android.permission.SYSTEM_ALERT_WINDOW") && !PermissionUtils.isHasOverlaysPermission((Context)this.getActivity())) {
            intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + this.getContext().getPackageName())));
            this.startActivityForResult(intent, this.getArguments().getInt(REQUEST_CODE));
            isRequestPermission = true;
        }
        if (!isRequestPermission) {
            this.requestPermission();
        }
    }

    public void requestPermission() {
        ArrayList permissions;
        if (PermissionUtils.isOverMarshmallow() && (permissions = this.getArguments().getStringArrayList(PERMISSION_GROUP)) != null && permissions.size() > 0) {
            this.requestPermissions(permissions.toArray(new String[permissions.size() - 1]), this.getArguments().getInt(REQUEST_CODE));
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        SoftReference reference = (SoftReference)CALLBACKS.get(requestCode);
        if (reference == null) {
            return;
        }
        OnPermission callback = (OnPermission)reference.get();
        if (callback == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permissions[i])) {
                grantResults[i] = PermissionUtils.isHasInstallPermission((Context)this.getActivity()) ? 0 : -1;
            }
            if ("android.permission.SYSTEM_ALERT_WINDOW".equals(permissions[i])) {
                grantResults[i] = PermissionUtils.isHasOverlaysPermission((Context)this.getActivity()) ? 0 : -1;
            }
            if (!"android.permission.ANSWER_PHONE_CALLS".equals(permissions[i]) && !"android.permission.READ_PHONE_NUMBERS".equals(permissions[i]) || PermissionUtils.isOverOreo()) continue;
            grantResults[i] = 0;
        }
        List<String> succeedPermissions = PermissionUtils.getSucceedPermissions(permissions, grantResults);
        if (succeedPermissions.size() == permissions.length) {
            callback.hasPermission(succeedPermissions, true);
        } else {
            List<String> failPermissions = PermissionUtils.getFailPermissions(permissions, grantResults);
            if (this.getArguments().getBoolean(REQUEST_CONSTANT) && PermissionUtils.isRequestDeniedPermission(this.getActivity(), failPermissions)) {
                this.requestPermission();
                return;
            }
            callback.noPermission(failPermissions, PermissionUtils.checkMorePermissionPermanentDenied(this.getActivity(), failPermissions));
            if (!succeedPermissions.isEmpty()) {
                callback.hasPermission(succeedPermissions, false);
            }
        }
        CALLBACKS.remove(requestCode);
        this.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (!this.mCallback && requestCode == this.getArguments().getInt(REQUEST_CODE)) {
            this.mCallback = true;
            HANDLER.postDelayed((Runnable)this, 500L);
        }
    }

    @Override
    public void run() {
        if (this.isAdded()) {
            this.requestPermission();
        }
    }
}

