/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import com.hjq.permissions.ManifestRegisterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class PermissionUtils {
    PermissionUtils() {
    }

    static boolean isOverMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    static boolean isOverOreo() {
        return Build.VERSION.SDK_INT >= 26;
    }

    static List<String> getManifestPermissions(Context context) {
        try {
            return Arrays.asList(context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return null;
        }
    }

    static boolean isHasInstallPermission(Context context) {
        if (PermissionUtils.isOverOreo()) {
            return context.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    static boolean isHasOverlaysPermission(Context context) {
        if (PermissionUtils.isOverMarshmallow()) {
            return Settings.canDrawOverlays((Context)context);
        }
        return true;
    }

    static ArrayList<String> getFailPermissions(Context context, List<String> permissions) {
        if (!PermissionUtils.isOverMarshmallow()) {
            return null;
        }
        ArrayList<String> failPermissions = null;
        for (String permission : permissions) {
            if (permission.equals("android.permission.REQUEST_INSTALL_PACKAGES")) {
                if (PermissionUtils.isHasInstallPermission(context)) continue;
                if (failPermissions == null) {
                    failPermissions = new ArrayList<String>();
                }
                failPermissions.add(permission);
                continue;
            }
            if (permission.equals("android.permission.SYSTEM_ALERT_WINDOW")) {
                if (PermissionUtils.isHasOverlaysPermission(context)) continue;
                if (failPermissions == null) {
                    failPermissions = new ArrayList();
                }
                failPermissions.add(permission);
                continue;
            }
            if ((permission.equals("android.permission.ANSWER_PHONE_CALLS") || permission.equals("android.permission.READ_PHONE_NUMBERS")) && !PermissionUtils.isOverOreo() || context.checkSelfPermission(permission) != -1) continue;
            if (failPermissions == null) {
                failPermissions = new ArrayList();
            }
            failPermissions.add(permission);
        }
        return failPermissions;
    }

    static boolean isRequestDeniedPermission(Activity activity, List<String> failPermissions) {
        for (String permission : failPermissions) {
            if (PermissionUtils.checkSinglePermissionPermanentDenied(activity, permission)) continue;
            return true;
        }
        return false;
    }

    static boolean checkMorePermissionPermanentDenied(Activity activity, List<String> permissions) {
        for (String permission : permissions) {
            if (!PermissionUtils.checkSinglePermissionPermanentDenied(activity, permission)) continue;
            return true;
        }
        return false;
    }

    static boolean checkSinglePermissionPermanentDenied(Activity activity, String permission) {
        if (permission.equals("android.permission.REQUEST_INSTALL_PACKAGES") || permission.equals("android.permission.SYSTEM_ALERT_WINDOW")) {
            return false;
        }
        if ((permission.equals("android.permission.ANSWER_PHONE_CALLS") || permission.equals("android.permission.READ_PHONE_NUMBERS")) && !PermissionUtils.isOverOreo()) {
            return false;
        }
        return PermissionUtils.isOverMarshmallow() && activity.checkSelfPermission(permission) == -1 && !activity.shouldShowRequestPermissionRationale(permission);
    }

    static List<String> getFailPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> failPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            failPermissions.add(permissions[i]);
        }
        return failPermissions;
    }

    static List<String> getSucceedPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> succeedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            succeedPermissions.add(permissions[i]);
        }
        return succeedPermissions;
    }

    static void checkPermissions(Activity activity, List<String> requestPermissions) {
        List<String> manifestPermissions = PermissionUtils.getManifestPermissions((Context)activity);
        if (manifestPermissions != null && !manifestPermissions.isEmpty()) {
            for (String permission : requestPermissions) {
                if (manifestPermissions.contains(permission)) continue;
                throw new ManifestRegisterException(permission);
            }
        } else {
            throw new ManifestRegisterException(null);
        }
    }

    static void checkTargetSdkVersion(Context context, List<String> requestPermissions) {
        if (requestPermissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") || requestPermissions.contains("android.permission.ANSWER_PHONE_CALLS") || requestPermissions.contains("android.permission.READ_PHONE_NUMBERS")) {
            if (context.getApplicationInfo().targetSdkVersion < 26) {
                throw new RuntimeException("The targetSdkVersion SDK must be 26 or more");
            }
        } else if (context.getApplicationInfo().targetSdkVersion < 23) {
            throw new RuntimeException("The targetSdkVersion SDK must be 23 or more");
        }
    }
}

