/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import com.hjq.permissions.OnPermission;
import com.hjq.permissions.PermissionFragment;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class XXPermissions {
    private Activity mActivity;
    private List<String> mPermissions = new ArrayList<String>();
    private boolean mConstant;

    private XXPermissions(Activity activity) {
        this.mActivity = activity;
    }

    public static XXPermissions with(Activity activity) {
        return new XXPermissions(activity);
    }

    public XXPermissions permission(String ... permissions) {
        this.mPermissions.addAll(Arrays.asList(permissions));
        return this;
    }

    public XXPermissions permission(String[] ... permissions) {
        for (String[] group : permissions) {
            this.mPermissions.addAll(Arrays.asList(group));
        }
        return this;
    }

    public XXPermissions permission(List<String> permissions) {
        this.mPermissions.addAll(permissions);
        return this;
    }

    public XXPermissions constantRequest() {
        this.mConstant = true;
        return this;
    }

    public void request(OnPermission call) {
        if (this.mPermissions == null || this.mPermissions.size() == 0) {
            this.mPermissions = PermissionUtils.getManifestPermissions((Context)this.mActivity);
        }
        if (this.mPermissions == null || this.mPermissions.size() == 0) {
            throw new IllegalArgumentException("The requested permission cannot be empty");
        }
        if (this.mActivity == null) {
            throw new IllegalArgumentException("The activity is empty");
        }
        if (call == null) {
            throw new IllegalArgumentException("The permission request callback interface must be implemented");
        }
        PermissionUtils.checkTargetSdkVersion((Context)this.mActivity, this.mPermissions);
        ArrayList<String> failPermissions = PermissionUtils.getFailPermissions((Context)this.mActivity, this.mPermissions);
        if (failPermissions == null || failPermissions.size() == 0) {
            call.hasPermission(this.mPermissions, true);
        } else {
            PermissionUtils.checkPermissions(this.mActivity, this.mPermissions);
            PermissionFragment.newInstant(new ArrayList<String>(this.mPermissions), this.mConstant).prepareRequest(this.mActivity, call);
        }
    }

    public static boolean isHasPermission(Context context, String ... permissions) {
        ArrayList<String> failPermissions = PermissionUtils.getFailPermissions(context, Arrays.asList(permissions));
        return failPermissions == null || failPermissions.size() == 0;
    }

    public static boolean isHasPermission(Context context, String[] ... permissions) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : permissions) {
            permissionList.addAll(Arrays.asList(group));
        }
        ArrayList<String> failPermissions = PermissionUtils.getFailPermissions(context, permissionList);
        return failPermissions == null || failPermissions.size() == 0;
    }

    public static void gotoPermissionSettings(Context context) {
        PermissionSettingPage.start(context, false);
    }

    public static void gotoPermissionSettings(Context context, boolean newTask) {
        PermissionSettingPage.start(context, newTask);
    }
}

