/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import com.hjq.permissions.ManifestRegisterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class PermissionUtils {
    PermissionUtils() {
    }

    static boolean isOverMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    static boolean isOverOreo() {
        return Build.VERSION.SDK_INT >= 26;
    }

    static List<String> getManifestPermissions(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            return Arrays.asList(pm.getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions);
        }
        catch (Exception e) {
            return null;
        }
    }

    static boolean isHasInstallPermission(Context context) {
        if (PermissionUtils.isOverOreo()) {
            if (context.getApplicationInfo().targetSdkVersion < 26) {
                throw new RuntimeException("The targetSdkVersion SDK must be 26 or more");
            }
            return context.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    static boolean isHasOverlaysPermission(Context context) {
        if (PermissionUtils.isOverMarshmallow()) {
            if (context.getApplicationInfo().targetSdkVersion < 23) {
                throw new RuntimeException("The targetSdkVersion SDK must be 23 or more");
            }
            return Settings.canDrawOverlays((Context)context);
        }
        return true;
    }

    static ArrayList<String> getFailPermissions(Context context, List<String> permissions) {
        if (context.getApplicationInfo().targetSdkVersion < 23) {
            throw new RuntimeException("The targetSdkVersion SDK must be 23 or more");
        }
        if (!PermissionUtils.isOverMarshmallow()) {
            return null;
        }
        ArrayList<String> failPermissions = null;
        for (String permission : permissions) {
            if (permission.equals("android.permission.REQUEST_INSTALL_PACKAGES")) {
                if (PermissionUtils.isHasInstallPermission(context)) continue;
                if (failPermissions == null) {
                    failPermissions = new ArrayList<String>();
                }
                failPermissions.add(permission);
                continue;
            }
            if (permission.equals("android.permission.SYSTEM_ALERT_WINDOW")) {
                if (PermissionUtils.isHasOverlaysPermission(context)) continue;
                if (failPermissions == null) {
                    failPermissions = new ArrayList();
                }
                failPermissions.add(permission);
                continue;
            }
            if (context.checkSelfPermission(permission) != -1) continue;
            if (failPermissions == null) {
                failPermissions = new ArrayList();
            }
            failPermissions.add(permission);
        }
        return failPermissions;
    }

    static boolean isRequestDeniedPermission(Activity activity, List<String> failPermissions) {
        for (String permission : failPermissions) {
            if (PermissionUtils.checkSinglePermissionPermanentDenied(activity, permission)) continue;
            return true;
        }
        return false;
    }

    static boolean checkMorePermissionPermanentDenied(Activity activity, List<String> permissions) {
        for (String permission : permissions) {
            if (!PermissionUtils.checkSinglePermissionPermanentDenied(activity, permission)) continue;
            return true;
        }
        return false;
    }

    static boolean checkSinglePermissionPermanentDenied(Activity activity, String permission) {
        if (permission.equals("android.permission.REQUEST_INSTALL_PACKAGES") || permission.equals("android.permission.SYSTEM_ALERT_WINDOW")) {
            return false;
        }
        return PermissionUtils.isOverMarshmallow() && activity.checkSelfPermission(permission) == -1 && !activity.shouldShowRequestPermissionRationale(permission);
    }

    static List<String> getFailPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> failPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            failPermissions.add(permissions[i]);
        }
        return failPermissions;
    }

    static List<String> getSucceedPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> succeedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            succeedPermissions.add(permissions[i]);
        }
        return succeedPermissions;
    }

    static void checkPermissions(Activity activity, List<String> requestPermissions) {
        List<String> manifest = PermissionUtils.getManifestPermissions((Context)activity);
        if (manifest != null && manifest.size() != 0) {
            for (String permission : requestPermissions) {
                if (manifest.contains(permission)) continue;
                throw new ManifestRegisterException(permission);
            }
        } else {
            throw new ManifestRegisterException(null);
        }
    }
}

