/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import com.hjq.permissions.OnPermission;
import com.hjq.permissions.PermissionFragment;
import com.hjq.permissions.PermissionSettingPage;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class XXPermissions {
    private Activity mActivity;
    private List<String> mPermissions;
    private boolean mConstant;

    private XXPermissions(Activity activity) {
        this.mActivity = activity;
    }

    public static XXPermissions with(Activity activity) {
        return new XXPermissions(activity);
    }

    public XXPermissions permission(String ... permissions) {
        this.mPermissions = Arrays.asList(permissions);
        return this;
    }

    public XXPermissions permission(String[] ... permissions) {
        this.mPermissions = new ArrayList<String>();
        for (String[] group : permissions) {
            this.mPermissions.addAll(Arrays.asList(group));
        }
        return this;
    }

    public XXPermissions permission(List<String> permissions) {
        this.mPermissions = permissions;
        return this;
    }

    public XXPermissions constantRequest() {
        this.mConstant = true;
        return this;
    }

    public void request(OnPermission call) {
        if (this.mPermissions == null || this.mPermissions.size() == 0) {
            this.mPermissions = PermissionUtils.getManifestPermissions((Context)this.mActivity);
        }
        if (this.mPermissions == null || this.mPermissions.size() == 0) {
            throw new IllegalArgumentException("The requested permission cannot be empty");
        }
        if (this.mActivity == null) {
            throw new IllegalArgumentException("The activity is empty");
        }
        if (call == null) {
            throw new IllegalArgumentException("The permission request callback interface must be implemented");
        }
        ArrayList<String> failPermissions = PermissionUtils.getFailPermissions((Context)this.mActivity, this.mPermissions);
        if (failPermissions == null) {
            call.hasPermission(this.mPermissions, true);
        } else {
            PermissionUtils.checkPermissions(this.mActivity, this.mPermissions);
            PermissionFragment.newInstant(new ArrayList<String>(this.mPermissions), this.mConstant).prepareRequest(this.mActivity, call);
        }
    }

    public static boolean isHasPermission(Context context, String ... permissions) {
        return PermissionUtils.getFailPermissions(context, Arrays.asList(permissions)) == null;
    }

    public static boolean isHasPermission(Context context, String[] ... permissions) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : permissions) {
            permissionList.addAll(Arrays.asList(group));
        }
        return PermissionUtils.getFailPermissions(context, permissionList) == null;
    }

    public static void gotoPermissionSettings(Context context) {
        PermissionSettingPage.start(context, false);
    }

    public static void gotoPermissionSettings(Context context, boolean newTask) {
        PermissionSettingPage.start(context, newTask);
    }
}

