/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.SparseArray;
import com.hjq.permissions.OnPermission;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class PermissionFragment
extends Fragment {
    private static final String PERMISSION_GROUP = "permission_group";
    private static final String REQUEST_CODE = "request_code";
    private static final String REQUEST_CONSTANT = "request_constant";
    private static final SparseArray<OnPermission> sContainer = new SparseArray();
    private static final int TIME_DELAY = 200;
    private static long sRequestTime;
    private boolean isBackCall;

    public static PermissionFragment newInstant(ArrayList<String> permissions, boolean constant) {
        int requestCode;
        PermissionFragment fragment = new PermissionFragment();
        Bundle bundle = new Bundle();
        while (sContainer.get(requestCode = new Random().nextInt(255)) != null) {
        }
        bundle.putInt(REQUEST_CODE, requestCode);
        bundle.putStringArrayList(PERMISSION_GROUP, permissions);
        bundle.putBoolean(REQUEST_CONSTANT, constant);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void prepareRequest(Activity activity, OnPermission call) {
        sContainer.put(this.getArguments().getInt(REQUEST_CODE), (Object)call);
        activity.getFragmentManager().beginTransaction().add((Fragment)this, activity.getClass().getName()).commit();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ArrayList permissions = this.getArguments().getStringArrayList(PERMISSION_GROUP);
        if (permissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") && !PermissionUtils.isHasInstallPermission((Context)this.getActivity()) || permissions.contains("android.permission.SYSTEM_ALERT_WINDOW") && !PermissionUtils.isHasOverlaysPermission((Context)this.getActivity())) {
            Intent intent;
            if (permissions.contains("android.permission.REQUEST_INSTALL_PACKAGES") && !PermissionUtils.isHasInstallPermission((Context)this.getActivity())) {
                intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES", Uri.parse((String)("package:" + this.getActivity().getPackageName())));
                this.startActivityForResult(intent, this.getArguments().getInt(REQUEST_CODE));
            }
            if (permissions.contains("android.permission.SYSTEM_ALERT_WINDOW") && !PermissionUtils.isHasOverlaysPermission((Context)this.getActivity())) {
                intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + this.getActivity().getPackageName())));
                this.startActivityForResult(intent, this.getArguments().getInt(REQUEST_CODE));
            }
            sRequestTime = System.currentTimeMillis();
        } else {
            this.requestPermission();
            sRequestTime = System.currentTimeMillis();
        }
    }

    public void requestPermission() {
        if (PermissionUtils.isOverMarshmallow()) {
            ArrayList permissions = this.getArguments().getStringArrayList(PERMISSION_GROUP);
            this.requestPermissions(permissions.toArray(new String[permissions.size() - 1]), this.getArguments().getInt(REQUEST_CODE));
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        OnPermission call = (OnPermission)sContainer.get(requestCode);
        if (call == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if ("android.permission.REQUEST_INSTALL_PACKAGES".equals(permissions[i])) {
                grantResults[i] = PermissionUtils.isHasInstallPermission((Context)this.getActivity()) ? 0 : -1;
            }
            if (!"android.permission.SYSTEM_ALERT_WINDOW".equals(permissions[i])) continue;
            grantResults[i] = PermissionUtils.isHasOverlaysPermission((Context)this.getActivity()) ? 0 : -1;
        }
        List<String> succeedPermissions = PermissionUtils.getSucceedPermissions(permissions, grantResults);
        if (succeedPermissions.size() == permissions.length) {
            call.hasPermission(succeedPermissions, true);
        } else {
            if (this.getArguments().getBoolean(REQUEST_CONSTANT) && System.currentTimeMillis() - sRequestTime > 200L) {
                this.requestPermission();
                return;
            }
            List<String> failPermissions = PermissionUtils.getFailPermissions(permissions, grantResults);
            call.noPermission(failPermissions, System.currentTimeMillis() - sRequestTime < 200L);
            if (!succeedPermissions.isEmpty()) {
                call.hasPermission(succeedPermissions, false);
            }
        }
        sContainer.remove(requestCode);
        this.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (!this.isBackCall && requestCode == this.getArguments().getInt(REQUEST_CODE)) {
            this.isBackCall = true;
            this.requestPermission();
        }
    }
}

