/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.manager;

import androidx.annotation.IntRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class PermissionRequestCodeManager {
    public static final int REQUEST_CODE_LIMIT_LOW_VALUE = 255;
    public static final int REQUEST_CODE_LIMIT_HIGH_VALUE = 65535;
    private static final List<Integer> REQUEST_CODE_ARRAY = new ArrayList<Integer>();
    private static final Random RANDOM = new Random();

    private PermissionRequestCodeManager() {
    }

    @IntRange(from=1L, to=65535L)
    public static synchronized int generateRandomRequestCode(@IntRange(from=1L, to=65535L) int maxRequestCode) {
        int minRequestCode;
        int requestCode;
        while ((requestCode = RANDOM.nextInt(maxRequestCode - (minRequestCode = maxRequestCode > 20000 ? maxRequestCode - 10000 : maxRequestCode / 2)) + minRequestCode) == 1025 || REQUEST_CODE_ARRAY.contains(requestCode)) {
        }
        REQUEST_CODE_ARRAY.add(requestCode);
        return requestCode;
    }

    public static synchronized void releaseRequestCode(int requestCode) {
        REQUEST_CODE_ARRAY.remove((Object)requestCode);
    }
}

