/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class ManageMediaPermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.MANAGE_MEDIA";
    public static final Parcelable.Creator<ManageMediaPermission> CREATOR = new Parcelable.Creator<ManageMediaPermission>(){

        public ManageMediaPermission createFromParcel(Parcel source) {
            return new ManageMediaPermission(source);
        }

        public ManageMediaPermission[] newArray(int size) {
            return new ManageMediaPermission[size];
        }
    };

    public ManageMediaPermission() {
    }

    private ManageMediaPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 31;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid12()) {
            return true;
        }
        return MediaStore.canManageMedia((Context)context);
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(3);
        if (PermissionVersion.isAndroid12()) {
            intent = new Intent("android.settings.REQUEST_MANAGE_MEDIA");
            intent.setData(this.getPackageNameUri(context));
            intentList.add(intent);
            intent = new Intent("android.settings.REQUEST_MANAGE_MEDIA");
            intentList.add(intent);
        }
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return true;
    }
}

