/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.hjq.device.compat.DeviceBrand;
import com.hjq.device.compat.DeviceOs;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class AccessNotificationPolicyPermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.ACCESS_NOTIFICATION_POLICY";
    public static final Parcelable.Creator<AccessNotificationPolicyPermission> CREATOR = new Parcelable.Creator<AccessNotificationPolicyPermission>(){

        public AccessNotificationPolicyPermission createFromParcel(Parcel source) {
            return new AccessNotificationPolicyPermission(source);
        }

        public AccessNotificationPolicyPermission[] newArray(int size) {
            return new AccessNotificationPolicyPermission[size];
        }
    };

    public AccessNotificationPolicyPermission() {
    }

    private AccessNotificationPolicyPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 23;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid6()) {
            return true;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
        if (notificationManager == null) {
            return false;
        }
        return notificationManager.isNotificationPolicyAccessGranted();
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context, boolean skipRequest) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(6);
        if (!(!PermissionVersion.isAndroid10() || DeviceOs.isHarmonyOs() || DeviceOs.isHarmonyOsNextAndroidCompatible() || DeviceOs.isMagicOs() || DeviceOs.isEmui() || DeviceBrand.isHuaWei() || DeviceBrand.isHonor())) {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_DETAIL_SETTINGS");
            intent.setData(this.getPackageNameUri(context));
            intentList.add(intent);
        }
        if (PermissionVersion.isAndroid6()) {
            intent = new Intent("android.settings.NOTIFICATION_POLICY_ACCESS_SETTINGS");
            intentList.add(intent);
        }
        intent = this.getApplicationDetailsSettingIntent(context);
        intentList.add(intent);
        intent = AccessNotificationPolicyPermission.getManageApplicationSettingIntent();
        intentList.add(intent);
        intent = AccessNotificationPolicyPermission.getApplicationSettingIntent();
        intentList.add(intent);
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return true;
    }
}

