/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.manager;

import android.support.annotation.Nullable;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.tools.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class AlreadyRequestPermissionsManager {
    private static final List<String> ALREADY_REQUEST_PERMISSIONS_LIST = new ArrayList<String>();

    private AlreadyRequestPermissionsManager() {
    }

    public static void addAlreadyRequestPermissions(@Nullable List<IPermission> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return;
        }
        for (IPermission permission : permissions) {
            String permissionName = permission.getPermissionName();
            if (PermissionUtils.containsPermission(ALREADY_REQUEST_PERMISSIONS_LIST, permissionName)) continue;
            ALREADY_REQUEST_PERMISSIONS_LIST.add(permissionName);
        }
    }

    public static boolean isAlreadyRequestPermissions(@Nullable IPermission permission) {
        if (permission == null) {
            return false;
        }
        return PermissionUtils.containsPermission(ALREADY_REQUEST_PERMISSIONS_LIST, permission.getPermissionName());
    }
}

