/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.fragment.factory;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.hjq.permissions.core.OnPermissionFragmentCallback;
import com.hjq.permissions.fragment.factory.PermissionFragmentFactory;
import com.hjq.permissions.fragment.impl.support.PermissionSupportFragment;
import com.hjq.permissions.fragment.impl.support.PermissionSupportFragmentByRequestPermissions;
import com.hjq.permissions.fragment.impl.support.PermissionSupportFragmentByStartActivity;
import com.hjq.permissions.manager.PermissionRequestCodeManager;
import com.hjq.permissions.permission.PermissionChannel;
import com.hjq.permissions.permission.base.IPermission;
import java.util.List;

public final class PermissionFragmentFactoryBySupport
extends PermissionFragmentFactory<FragmentActivity, FragmentManager> {
    public PermissionFragmentFactoryBySupport(@NonNull FragmentActivity activity, @NonNull FragmentManager fragmentManager) {
        super(activity, fragmentManager);
    }

    @Override
    public void createAndCommitFragment(@NonNull List<IPermission> permissions, @NonNull PermissionChannel permissionChannel, @Nullable OnPermissionFragmentCallback callback) {
        int maxRequestCode;
        PermissionSupportFragment fragment = permissionChannel == PermissionChannel.REQUEST_PERMISSIONS ? new PermissionSupportFragmentByRequestPermissions() : new PermissionSupportFragmentByStartActivity();
        if (permissionChannel == PermissionChannel.REQUEST_PERMISSIONS) {
            try {
                FragmentActivity activity = (FragmentActivity)this.getActivity();
                activity.validateRequestPermissionsRequestCode(65535);
                maxRequestCode = 65535;
            }
            catch (IllegalArgumentException ignore) {
                maxRequestCode = 255;
            }
            catch (Exception ignore) {
                maxRequestCode = 65535;
            }
        } else {
            maxRequestCode = 65535;
        }
        int requestCode = PermissionRequestCodeManager.generateRandomRequestCode(maxRequestCode);
        fragment.setArguments(this.generatePermissionArguments(permissions, requestCode));
        fragment.setRetainInstance(true);
        fragment.setNonSystemRestartMark(true);
        fragment.setPermissionFragmentCallback(callback);
        fragment.commitFragmentAttach((FragmentManager)this.getFragmentManager());
    }
}

