/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.PermissionLists;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.DangerousPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.List;

public final class BluetoothScanPermission
extends DangerousPermission {
    public static final String PERMISSION_NAME = "android.permission.BLUETOOTH_SCAN";
    public static final Parcelable.Creator<BluetoothScanPermission> CREATOR = new Parcelable.Creator<BluetoothScanPermission>(){

        public BluetoothScanPermission createFromParcel(Parcel source) {
            return new BluetoothScanPermission(source);
        }

        public BluetoothScanPermission[] newArray(int size) {
            return new BluetoothScanPermission[size];
        }
    };

    public BluetoothScanPermission() {
    }

    private BluetoothScanPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public String getPermissionGroup(@NonNull Context context) {
        return PermissionVersion.isAndroid12() ? "nearby_devices_group" : "location_group";
    }

    @Override
    public int getFromAndroidVersion(@NonNull Context context) {
        return 31;
    }

    @Override
    public int getMinTargetSdkVersion(@NonNull Context context) {
        return 23;
    }

    @Override
    @NonNull
    public List<IPermission> getOldPermissions(Context context) {
        return PermissionUtils.asArrayList(PermissionLists.getAccessFineLocationPermission());
    }

    @Override
    protected boolean isGrantedPermissionByLowVersion(@NonNull Context context, boolean skipRequest) {
        return PermissionLists.getAccessFineLocationPermission().isGrantedPermission(context, skipRequest);
    }

    @Override
    protected boolean isDoNotAskAgainPermissionByLowVersion(@NonNull Activity activity) {
        return PermissionLists.getAccessFineLocationPermission().isDoNotAskAgainPermission(activity);
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo manifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, manifestInfo, permissionInfoList, currentPermissionInfo);
        if (this.getFromAndroidVersion((Context)activity) > BluetoothScanPermission.getMinSdkVersion((Context)activity, manifestInfo)) {
            BluetoothScanPermission.checkPermissionRegistrationStatus(permissionInfoList, "android.permission.BLUETOOTH_ADMIN", 30);
            BluetoothScanPermission.checkPermissionRegistrationStatus(permissionInfoList, "android.permission.ACCESS_FINE_LOCATION", 30);
        }
        if (PermissionUtils.containsPermission(requestList, "android.permission.ACCESS_FINE_LOCATION")) {
            return;
        }
        if (currentPermissionInfo == null) {
            return;
        }
        if (currentPermissionInfo.neverForLocation()) {
            return;
        }
        String maxSdkVersionString = currentPermissionInfo.maxSdkVersion != Integer.MAX_VALUE ? "android:maxSdkVersion=\"" + currentPermissionInfo.maxSdkVersion + "\" " : "";
        throw new IllegalArgumentException("If your app doesn't use " + currentPermissionInfo.name + " to get physical location, please change the <uses-permission android:name=\"" + currentPermissionInfo.name + "\" " + maxSdkVersionString + "/> node in the manifest file to <uses-permission android:name=\"" + currentPermissionInfo.name + "\" android:usesPermissionFlags=\"neverForLocation\" " + maxSdkVersionString + "/> node, if your app need use \"" + currentPermissionInfo.name + "\" to get physical location, also need to add \"" + "android.permission.ACCESS_FINE_LOCATION" + "\" permissions");
    }
}

