/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.tools;

import android.app.Activity;
import android.app.Fragment;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public final class PermissionChecker {
    public static void checkActivityStatus(@Nullable Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("The instance of the context must be an activity object");
        }
        if (activity.isFinishing()) {
            throw new IllegalStateException("The activity has been finishing, please manually determine the status of the activity");
        }
        if (activity.isDestroyed()) {
            throw new IllegalStateException("The activity has been destroyed, please manually determine the status of the activity");
        }
    }

    public static void checkSupportFragmentStatus(@NonNull android.support.v4.app.Fragment supportFragment) {
        if (!supportFragment.isAdded()) {
            throw new IllegalStateException("This support fragment has no binding added, please manually determine the status of the support fragment");
        }
        if (supportFragment.isRemoving()) {
            throw new IllegalStateException("This support fragment has been removed, please manually determine the status of the support fragment");
        }
    }

    public static void checkAppFragmentStatus(@NonNull Fragment appFragment) {
        if (!appFragment.isAdded()) {
            throw new IllegalStateException("This app fragment has no binding added, please manually determine the status of the app fragment");
        }
        if (appFragment.isRemoving()) {
            throw new IllegalStateException("This app fragment has been removed, please manually determine the status of the app fragment");
        }
    }

    public static void checkPermissionList(@NonNull Activity activity, @Nullable List<IPermission> requestList, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (requestList == null || requestList.isEmpty()) {
            throw new IllegalArgumentException("The requested permission cannot be empty");
        }
        for (IPermission permission2 : requestList) {
            PermissionChecker.checkPermissionParcelable(permission2);
            permission2.checkCompliance(activity, requestList, androidManifestInfo);
        }
    }

    public static void checkPermissionParcelable(@NonNull IPermission permission2) {
        Object creatorObject;
        Class<?> clazz = permission2.getClass();
        String className = clazz.getName();
        Field creatorField = null;
        try {
            creatorField = permission2.getClass().getDeclaredField("CREATOR");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (creatorField == null) {
            throw new IllegalArgumentException("This permission class does not define the CREATOR field");
        }
        try {
            creatorObject = creatorField.get(null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The CREATOR field in the " + className + " has an access exception. Please modify CREATOR field with \"public static final\"");
        }
        if (!(creatorObject instanceof Parcelable.Creator)) {
            throw new IllegalArgumentException("The CREATOR field in this " + className + " is not of type " + Parcelable.Creator.class.getName());
        }
        Type genericType = creatorField.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("The generic type defined for the CREATOR field in this " + className + " is empty");
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 1) {
            throw new IllegalArgumentException("The number of generics defined in the CREATOR field of this " + className + " can only be one");
        }
        Type typeArgument = typeArguments[0];
        if (!(typeArgument instanceof Class) || !clazz.isAssignableFrom((Class)typeArgument)) {
            throw new IllegalArgumentException("The generic type defined in the CREATOR field of this " + className + " is incorrect");
        }
        Parcelable.Creator parcelableCreator = (Parcelable.Creator)creatorObject;
        Object[] array = parcelableCreator.newArray(0);
        if (array == null) {
            throw new IllegalArgumentException("The newArray method of the CREATOR field in this " + className + " returns an empty value. This method cannot return an empty value");
        }
    }
}

