/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.ApplicationManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.PermissionLists;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.DangerousPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.List;

public final class ReadExternalStoragePermission
extends DangerousPermission {
    public static final String PERMISSION_NAME = "android.permission.READ_EXTERNAL_STORAGE";
    static final String META_DATA_KEY_SCOPED_STORAGE = "ScopedStorage";
    public static final Parcelable.Creator<ReadExternalStoragePermission> CREATOR = new Parcelable.Creator<ReadExternalStoragePermission>(){

        public ReadExternalStoragePermission createFromParcel(Parcel source) {
            return new ReadExternalStoragePermission(source);
        }

        public ReadExternalStoragePermission[] newArray(int size) {
            return new ReadExternalStoragePermission[size];
        }
    };

    public ReadExternalStoragePermission() {
    }

    private ReadExternalStoragePermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public String getPermissionGroup() {
        return "storage_group";
    }

    @Override
    public int getFromAndroidVersion() {
        return 23;
    }

    @Override
    protected boolean isGrantedPermissionByStandardVersion(@NonNull Context context, boolean skipRequest) {
        if (PermissionVersion.isAndroid13() && PermissionVersion.getTargetVersion(context) >= 33) {
            return PermissionLists.getReadMediaImagesPermission().isGrantedPermission(context, skipRequest) && PermissionLists.getReadMediaVideoPermission().isGrantedPermission(context, skipRequest) && PermissionLists.getReadMediaAudioPermission().isGrantedPermission(context, skipRequest);
        }
        return super.isGrantedPermissionByStandardVersion(context, skipRequest);
    }

    @Override
    protected boolean isDoNotAskAgainPermissionByStandardVersion(@NonNull Activity activity) {
        if (PermissionVersion.isAndroid13() && PermissionVersion.getTargetVersion((Context)activity) >= 33) {
            return PermissionLists.getReadMediaImagesPermission().isDoNotAskAgainPermission(activity) && PermissionLists.getReadMediaVideoPermission().isDoNotAskAgainPermission(activity) && PermissionLists.getReadMediaAudioPermission().isDoNotAskAgainPermission(activity);
        }
        return super.isDoNotAskAgainPermissionByStandardVersion(activity);
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestList, @NonNull AndroidManifestInfo androidManifestInfo, @NonNull List<PermissionManifestInfo> permissionInfoList, @Nullable PermissionManifestInfo currentPermissionInfo) {
        super.checkSelfByManifestFile(activity, requestList, androidManifestInfo, permissionInfoList, currentPermissionInfo);
        if (PermissionUtils.containsPermission(requestList, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return;
        }
        ApplicationManifestInfo applicationManifestInfo = androidManifestInfo.applicationManifestInfo;
        if (applicationManifestInfo == null) {
            return;
        }
        int targetSdkVersion = PermissionVersion.getTargetVersion((Context)activity);
        boolean scopedStorage = PermissionUtils.getBooleanByMetaData((Context)activity, META_DATA_KEY_SCOPED_STORAGE, false);
        if (targetSdkVersion >= 29 && !applicationManifestInfo.requestLegacyExternalStorage && !scopedStorage) {
            throw new IllegalStateException("Please register the android:requestLegacyExternalStorage=\"true\" attribute in the AndroidManifest.xml file, otherwise it will cause incompatibility with the old version");
        }
        if (targetSdkVersion >= 30 && !scopedStorage) {
            throw new IllegalArgumentException("The storage permission application is abnormal. If you have adapted the scope storage, please register the <meta-data android:name=\"ScopedStorage\" android:value=\"true\" /> attribute in the AndroidManifest.xml file. If there is no adaptation scope storage, please use \"android.permission.MANAGE_EXTERNAL_STORAGE\" to apply for permission");
        }
    }

    @Override
    protected void checkSelfByRequestPermissions(@NonNull Activity activity, @NonNull List<IPermission> requestList) {
        super.checkSelfByRequestPermissions(activity, requestList);
        if (PermissionVersion.getTargetVersion((Context)activity) >= 33) {
            throw new IllegalArgumentException("When the project targetSdkVersion >= 33, the \"android.permission.READ_EXTERNAL_STORAGE\" permission cannot be applied for, and some problems will occur.Because after testing, if targetSdkVersion >= 33 applies for \"android.permission.READ_EXTERNAL_STORAGE\" or \"android.permission.WRITE_EXTERNAL_STORAGE\", it will be directly rejected by the system and no authorization dialog box will be displayed.If the App has been adapted for scoped storage, the should be requested \"android.permission.READ_MEDIA_IMAGES\" or \"android.permission.READ_MEDIA_VIDEO\" or \"android.permission.READ_MEDIA_AUDIO\" permission.If the App does not need to adapt scoped storage, the should be requested \"android.permission.MANAGE_EXTERNAL_STORAGE\" permission");
        }
    }
}

