/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.dangerous;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.permission.PermissionLists;
import com.hjq.permissions.permission.PermissionPageType;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.DangerousPermission;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import com.hjq.permissions.tools.PhoneRomUtils;
import java.util.List;

public final class AccessBackgroundLocationPermission
extends DangerousPermission {
    public static final String PERMISSION_NAME = "android.permission.ACCESS_BACKGROUND_LOCATION";
    public static final Parcelable.Creator<AccessBackgroundLocationPermission> CREATOR = new Parcelable.Creator<AccessBackgroundLocationPermission>(){

        public AccessBackgroundLocationPermission createFromParcel(Parcel source) {
            return new AccessBackgroundLocationPermission(source);
        }

        public AccessBackgroundLocationPermission[] newArray(int size) {
            return new AccessBackgroundLocationPermission[size];
        }
    };

    public AccessBackgroundLocationPermission() {
    }

    private AccessBackgroundLocationPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    @NonNull
    public PermissionPageType getPermissionPageType(@NonNull Context context) {
        if (PhoneRomUtils.isHyperOs() || PhoneRomUtils.isMiui()) {
            return PermissionPageType.TRANSPARENT_ACTIVITY;
        }
        if (PermissionVersion.isAndroid10() && !PermissionVersion.isAndroid11()) {
            return PermissionPageType.TRANSPARENT_ACTIVITY;
        }
        return PermissionPageType.OPAQUE_ACTIVITY;
    }

    @Override
    public String getPermissionGroup() {
        return "location_group";
    }

    @Override
    public int getFromAndroidVersion() {
        return 29;
    }

    @Override
    @NonNull
    public List<IPermission> getForegroundPermissions(@NonNull Context context) {
        if (PermissionVersion.isAndroid12()) {
            return PermissionUtils.asArrayList(PermissionLists.getAccessFineLocationPermission(), PermissionLists.getAccessCoarseLocationPermission());
        }
        return PermissionUtils.asArrayList(PermissionLists.getAccessFineLocationPermission());
    }

    @Override
    public boolean isBackgroundPermission(@NonNull Context context) {
        return true;
    }

    @Override
    protected boolean isGrantedPermissionByStandardVersion(@NonNull Context context, boolean skipRequest) {
        if (PermissionVersion.isAndroid12() ? !PermissionLists.getAccessFineLocationPermission().isGrantedPermission(context, skipRequest) && !PermissionLists.getAccessCoarseLocationPermission().isGrantedPermission(context, skipRequest) : !PermissionLists.getAccessFineLocationPermission().isGrantedPermission(context, skipRequest)) {
            return false;
        }
        return super.isGrantedPermissionByStandardVersion(context, skipRequest);
    }

    @Override
    protected boolean isGrantedPermissionByLowVersion(@NonNull Context context, boolean skipRequest) {
        return PermissionLists.getAccessFineLocationPermission().isGrantedPermission(context, skipRequest);
    }

    @Override
    protected boolean isDoNotAskAgainPermissionByStandardVersion(@NonNull Activity activity) {
        if (PermissionVersion.isAndroid12()) {
            if (!PermissionLists.getAccessFineLocationPermission().isGrantedPermission((Context)activity) && !PermissionLists.getAccessCoarseLocationPermission().isGrantedPermission((Context)activity)) {
                return PermissionLists.getAccessFineLocationPermission().isDoNotAskAgainPermission(activity) && PermissionLists.getAccessCoarseLocationPermission().isDoNotAskAgainPermission(activity);
            }
        } else if (!PermissionLists.getAccessFineLocationPermission().isGrantedPermission((Context)activity)) {
            return PermissionLists.getAccessFineLocationPermission().isDoNotAskAgainPermission(activity);
        }
        return super.isDoNotAskAgainPermissionByStandardVersion(activity);
    }

    @Override
    protected boolean isDoNotAskAgainPermissionByLowVersion(@NonNull Activity activity) {
        return PermissionLists.getAccessFineLocationPermission().isDoNotAskAgainPermission(activity);
    }

    @Override
    public int getRequestIntervalTime(@NonNull Context context) {
        return this.isSupportRequestPermission(context) ? 150 : 0;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions, @NonNull AndroidManifestInfo androidManifestInfo, @NonNull List<PermissionManifestInfo> permissionManifestInfoList, @Nullable PermissionManifestInfo currentPermissionManifestInfo) {
        super.checkSelfByManifestFile(activity, requestPermissions, androidManifestInfo, permissionManifestInfoList, currentPermissionManifestInfo);
        if (PermissionVersion.getTargetVersion((Context)activity) >= 31) {
            AccessBackgroundLocationPermission.checkPermissionRegistrationStatus(permissionManifestInfoList, "android.permission.ACCESS_COARSE_LOCATION");
            AccessBackgroundLocationPermission.checkPermissionRegistrationStatus(permissionManifestInfoList, "android.permission.ACCESS_FINE_LOCATION");
        } else {
            AccessBackgroundLocationPermission.checkPermissionRegistrationStatus(permissionManifestInfoList, "android.permission.ACCESS_FINE_LOCATION");
        }
    }

    @Override
    protected void checkSelfByRequestPermissions(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions) {
        super.checkSelfByRequestPermissions(activity, requestPermissions);
        if (PermissionVersion.getTargetVersion((Context)activity) >= 31 && PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_COARSE_LOCATION") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
            throw new IllegalArgumentException("Applying for background positioning permissions must include \"android.permission.ACCESS_FINE_LOCATION\"");
        }
        int thisPermissionIndex = -1;
        int accessFineLocationPermissionIndex = -1;
        int accessCoarseLocationPermissionIndex = -1;
        for (int i = 0; i < requestPermissions.size(); ++i) {
            IPermission permission2 = requestPermissions.get(i);
            if (PermissionUtils.equalsPermission(permission2, this)) {
                thisPermissionIndex = i;
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_FINE_LOCATION")) {
                accessFineLocationPermissionIndex = i;
                continue;
            }
            if (!PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_COARSE_LOCATION")) continue;
            accessCoarseLocationPermissionIndex = i;
        }
        if (accessFineLocationPermissionIndex != -1 && accessFineLocationPermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the " + this.getPermissionName() + "\" permission after the \"" + "android.permission.ACCESS_FINE_LOCATION" + "\" permission");
        }
        if (accessCoarseLocationPermissionIndex != -1 && accessCoarseLocationPermissionIndex > thisPermissionIndex) {
            throw new IllegalArgumentException("Please place the \"" + this.getPermissionName() + "\" permission after the \"" + "android.permission.ACCESS_COARSE_LOCATION" + "\" permission");
        }
    }
}

