/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.core;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionDescription;
import com.hjq.permissions.OnPermissionInterceptor;
import com.hjq.permissions.core.OnPermissionFlowCallback;
import com.hjq.permissions.fragment.factory.PermissionFragmentFactory;
import com.hjq.permissions.manager.ActivityOrientationManager;
import com.hjq.permissions.permission.PermissionType;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.tools.PermissionApi;
import com.hjq.permissions.tools.PermissionTaskHandler;
import com.hjq.permissions.tools.PermissionUtils;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class RequestPermissionLogicPresenter {
    @NonNull
    private final Activity mActivity;
    @NonNull
    private final List<IPermission> mRequestPermissions;
    @NonNull
    private final PermissionFragmentFactory<?, ?> mFragmentFactory;
    @NonNull
    private final OnPermissionInterceptor mPermissionInterceptor;
    @NonNull
    private final OnPermissionDescription mPermissionDescription;
    @Nullable
    private final OnPermissionCallback mCallBack;

    public RequestPermissionLogicPresenter(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions, @NonNull PermissionFragmentFactory<?, ?> fragmentFactory, @NonNull OnPermissionInterceptor permissionInterceptor, @NonNull OnPermissionDescription permissionDescription, @Nullable OnPermissionCallback callback) {
        this.mActivity = activity;
        this.mRequestPermissions = requestPermissions;
        this.mFragmentFactory = fragmentFactory;
        this.mPermissionInterceptor = permissionInterceptor;
        this.mPermissionDescription = permissionDescription;
        this.mCallBack = callback;
    }

    public void request() {
        if (this.mRequestPermissions.isEmpty()) {
            return;
        }
        List<List<IPermission>> unauthorizedPermissions = RequestPermissionLogicPresenter.getUnauthorizedPermissions(this.mActivity, this.mRequestPermissions);
        if (unauthorizedPermissions.isEmpty()) {
            this.handlePermissionRequestResult();
            return;
        }
        final Iterator<List<IPermission>> iterator = unauthorizedPermissions.iterator();
        List<IPermission> firstPermissions = null;
        while (iterator.hasNext() && (firstPermissions == null || firstPermissions.isEmpty())) {
            firstPermissions = iterator.next();
        }
        if (firstPermissions == null || firstPermissions.isEmpty()) {
            this.handlePermissionRequestResult();
            return;
        }
        final Activity activity = this.mActivity;
        final PermissionFragmentFactory<?, ?> fragmentFactory = this.mFragmentFactory;
        final OnPermissionDescription permissionDescription = this.mPermissionDescription;
        ActivityOrientationManager.lockActivityOrientation(activity);
        RequestPermissionLogicPresenter.requestPermissions(activity, firstPermissions, fragmentFactory, permissionDescription, new Runnable(){

            @Override
            public void run() {
                List nextPermissions = null;
                while (iterator.hasNext()) {
                    nextPermissions = (List)iterator.next();
                    if (nextPermissions == null || nextPermissions.isEmpty()) continue;
                    if (!PermissionApi.isGrantedPermissions((Context)activity, nextPermissions)) break;
                    nextPermissions = null;
                }
                if (nextPermissions == null || nextPermissions.isEmpty()) {
                    RequestPermissionLogicPresenter.this.postDelayedHandlerRequestPermissionsResult();
                    return;
                }
                IPermission firstNextPermission = (IPermission)nextPermissions.get(0);
                if (firstNextPermission.isBackgroundPermission((Context)activity)) {
                    List<IPermission> foregroundPermissions = firstNextPermission.getForegroundPermissions((Context)activity);
                    boolean grantedForegroundPermission = false;
                    if (foregroundPermissions != null && !foregroundPermissions.isEmpty()) {
                        for (IPermission foregroundPermission : foregroundPermissions) {
                            if (!foregroundPermission.isGrantedPermission((Context)activity)) continue;
                            grantedForegroundPermission = true;
                        }
                    }
                    if (!grantedForegroundPermission) {
                        this.run();
                        return;
                    }
                }
                List finalPermissions = nextPermissions;
                int maxWaitTimeByPermissions = PermissionApi.getMaxIntervalTimeByPermissions((Context)activity, nextPermissions);
                if (maxWaitTimeByPermissions == 0) {
                    RequestPermissionLogicPresenter.requestPermissions(activity, finalPermissions, fragmentFactory, permissionDescription, this);
                } else {
                    PermissionTaskHandler.sendTask(() -> RequestPermissionLogicPresenter.requestPermissions(activity, finalPermissions, fragmentFactory, permissionDescription, this), maxWaitTimeByPermissions);
                }
            }
        });
    }

    private static List<List<IPermission>> getUnauthorizedPermissions(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions) {
        ArrayList<List<IPermission>> unauthorizedPermissions = new ArrayList<List<IPermission>>(requestPermissions.size());
        ArrayList<IPermission> alreadyDonePermissions = new ArrayList<IPermission>(requestPermissions.size());
        for (int i = 0; i < requestPermissions.size(); ++i) {
            ArrayList<IPermission> foregroundPermissions;
            IPermission permission = requestPermissions.get(i);
            if (PermissionUtils.containsPermission(alreadyDonePermissions, permission)) continue;
            alreadyDonePermissions.add(permission);
            if (!permission.isSupportRequestPermission((Context)activity) || permission.isGrantedPermission((Context)activity)) continue;
            if (permission.getPermissionType() == PermissionType.SPECIAL) {
                unauthorizedPermissions.add(PermissionUtils.asArrayList(permission));
                continue;
            }
            String permissionGroup = permission.getPermissionGroup();
            if (TextUtils.isEmpty((CharSequence)permissionGroup)) {
                unauthorizedPermissions.add(PermissionUtils.asArrayList(permission));
                continue;
            }
            ArrayList<IPermission> todoPermissions = null;
            for (int j = i; j < requestPermissions.size(); ++j) {
                IPermission todoPermission = requestPermissions.get(j);
                if (!PermissionUtils.equalsString(todoPermission.getPermissionGroup(), permissionGroup) || !todoPermission.isSupportRequestPermission((Context)activity) || todoPermission.isGrantedPermission((Context)activity)) continue;
                if (todoPermissions == null) {
                    todoPermissions = new ArrayList<IPermission>();
                }
                todoPermissions.add(todoPermission);
                if (PermissionUtils.containsPermission(alreadyDonePermissions, todoPermission)) continue;
                alreadyDonePermissions.add(todoPermission);
            }
            if (todoPermissions == null || todoPermissions.isEmpty() || PermissionApi.isGrantedPermissions((Context)activity, (List<IPermission>)todoPermissions)) continue;
            ArrayList<IPermission> backgroundPermissions = null;
            Iterator iterator = todoPermissions.iterator();
            while (iterator.hasNext()) {
                IPermission todoPermission = (IPermission)iterator.next();
                if (!todoPermission.isBackgroundPermission((Context)activity)) continue;
                iterator.remove();
                backgroundPermissions = new ArrayList<IPermission>();
                backgroundPermissions.add(todoPermission);
                break;
            }
            if (!(foregroundPermissions = todoPermissions).isEmpty()) {
                unauthorizedPermissions.add(foregroundPermissions);
            }
            if (backgroundPermissions == null || backgroundPermissions.isEmpty()) continue;
            unauthorizedPermissions.add((List<IPermission>)backgroundPermissions);
        }
        return unauthorizedPermissions;
    }

    private static void requestPermissions(final @NonNull Activity activity, final List<IPermission> permissions, @NonNull PermissionFragmentFactory<?, ?> fragmentFactory, final @NonNull OnPermissionDescription permissionDescription, final @NonNull Runnable finishRunnable) {
        PermissionType permissionType;
        if (permissions.isEmpty()) {
            finishRunnable.run();
            return;
        }
        PermissionType permissionType2 = permissionType = PermissionApi.areAllDangerousPermission(permissions) ? PermissionType.DANGEROUS : PermissionType.SPECIAL;
        if (permissionType == PermissionType.DANGEROUS && !PermissionVersion.isAndroid6()) {
            finishRunnable.run();
            return;
        }
        Runnable continueRequestRunnable = () -> fragmentFactory.createAndCommitFragment(permissions, permissionType, new OnPermissionFlowCallback(){

            @Override
            public void onRequestPermissionNow() {
                permissionDescription.onRequestPermissionStart(activity, permissions);
            }

            @Override
            public void onRequestPermissionFinish() {
                permissionDescription.onRequestPermissionEnd(activity, permissions);
                finishRunnable.run();
            }

            @Override
            public void onRequestPermissionAnomaly() {
                permissionDescription.onRequestPermissionEnd(activity, permissions);
            }
        });
        permissionDescription.askWhetherRequestPermission(activity, permissions, continueRequestRunnable, finishRunnable);
    }

    private void postDelayedHandlerRequestPermissionsResult() {
        PermissionTaskHandler.sendTask(this::handlePermissionRequestResult, 100L);
    }

    private void postDelayedUnlockActivityOrientation(@NonNull Activity activity) {
        PermissionTaskHandler.sendTask(() -> ActivityOrientationManager.unlockActivityOrientation(activity), 100L);
    }

    private void handlePermissionRequestResult() {
        OnPermissionCallback callback = this.mCallBack;
        OnPermissionInterceptor interceptor = this.mPermissionInterceptor;
        List<IPermission> requestPermissions = this.mRequestPermissions;
        Activity activity = this.mActivity;
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        ArrayList<IPermission> grantedPermissions = new ArrayList<IPermission>(requestPermissions.size());
        ArrayList<IPermission> deniedPermissions = new ArrayList<IPermission>(requestPermissions.size());
        for (IPermission permission : requestPermissions) {
            if (permission.isGrantedPermission((Context)activity, false)) {
                grantedPermissions.add(permission);
                continue;
            }
            deniedPermissions.add(permission);
        }
        if (grantedPermissions.size() == requestPermissions.size()) {
            interceptor.grantedPermissionRequest(activity, requestPermissions, grantedPermissions, true, callback);
            interceptor.finishPermissionRequest(activity, requestPermissions, false, callback);
            this.postDelayedUnlockActivityOrientation(activity);
            return;
        }
        interceptor.deniedPermissionRequest(activity, requestPermissions, deniedPermissions, PermissionApi.isDoNotAskAgainPermissions(activity, deniedPermissions), callback);
        if (!grantedPermissions.isEmpty()) {
            interceptor.grantedPermissionRequest(activity, requestPermissions, grantedPermissions, false, callback);
        }
        interceptor.finishPermissionRequest(activity, requestPermissions, false, callback);
        this.postDelayedUnlockActivityOrientation(activity);
    }
}

