/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionVersion;
import java.util.ArrayList;
import java.util.List;

public final class PackageUsageStatsPermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.PACKAGE_USAGE_STATS";
    public static final Parcelable.Creator<PackageUsageStatsPermission> CREATOR = new Parcelable.Creator<PackageUsageStatsPermission>(){

        public PackageUsageStatsPermission createFromParcel(Parcel source) {
            return new PackageUsageStatsPermission(source);
        }

        public PackageUsageStatsPermission[] newArray(int size) {
            return new PackageUsageStatsPermission[size];
        }
    };

    public PackageUsageStatsPermission() {
    }

    private PackageUsageStatsPermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion() {
        return 21;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        if (!PermissionVersion.isAndroid5()) {
            return true;
        }
        return PackageUsageStatsPermission.checkOpPermission(context, "android:get_usage_stats", false);
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context) {
        Intent intent;
        ArrayList<Intent> intentList = new ArrayList<Intent>(3);
        if (PermissionVersion.isAndroid10()) {
            intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            intent.setData(this.getPackageNameUri(context));
            intentList.add(intent);
        }
        if (PermissionVersion.isAndroid5()) {
            intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            intentList.add(intent);
        }
        intent = this.getAndroidSettingIntent();
        intentList.add(intent);
        return intentList;
    }

    @Override
    protected boolean isRegisterPermissionByManifestFile() {
        return true;
    }
}

