/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions.permission.special;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.manifest.AndroidManifestInfo;
import com.hjq.permissions.manifest.node.PermissionManifestInfo;
import com.hjq.permissions.manifest.node.ServiceManifestInfo;
import com.hjq.permissions.permission.base.IPermission;
import com.hjq.permissions.permission.common.SpecialPermission;
import com.hjq.permissions.tools.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class BindVpnServicePermission
extends SpecialPermission {
    public static final String PERMISSION_NAME = "android.permission.BIND_VPN_SERVICE";
    public static final Parcelable.Creator<BindVpnServicePermission> CREATOR = new Parcelable.Creator<BindVpnServicePermission>(){

        public BindVpnServicePermission createFromParcel(Parcel source) {
            return new BindVpnServicePermission(source);
        }

        public BindVpnServicePermission[] newArray(int size) {
            return new BindVpnServicePermission[size];
        }
    };

    public BindVpnServicePermission() {
    }

    private BindVpnServicePermission(Parcel in) {
        super(in);
    }

    @Override
    @NonNull
    public String getPermissionName() {
        return PERMISSION_NAME;
    }

    @Override
    public int getFromAndroidVersion() {
        return 14;
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, boolean skipRequest) {
        return VpnService.prepare((Context)context) == null;
    }

    @Override
    @NonNull
    public List<Intent> getPermissionSettingIntents(@NonNull Context context) {
        ArrayList<Intent> intentList = new ArrayList<Intent>(2);
        intentList.add(VpnService.prepare((Context)context));
        intentList.add(this.getAndroidSettingIntent());
        return intentList;
    }

    @Override
    protected void checkSelfByManifestFile(@NonNull Activity activity, @NonNull List<IPermission> requestPermissions, @NonNull AndroidManifestInfo androidManifestInfo, @NonNull List<PermissionManifestInfo> permissionManifestInfoList, @Nullable PermissionManifestInfo currentPermissionManifestInfo) {
        super.checkSelfByManifestFile(activity, requestPermissions, androidManifestInfo, permissionManifestInfoList, currentPermissionManifestInfo);
        List<ServiceManifestInfo> serviceManifestInfoList = androidManifestInfo.serviceManifestInfoList;
        for (int i = 0; i < serviceManifestInfoList.size(); ++i) {
            String permission2 = serviceManifestInfoList.get((int)i).permission;
            if (permission2 == null || !PermissionUtils.equalsPermission((IPermission)this, permission2)) continue;
            return;
        }
        throw new IllegalArgumentException("No Service was found to have registered the android:permission=\"" + this.getPermissionName() + "\" property, Please register this property to VpnService subclass by AndroidManifest.xml file, otherwise it will lead to can't apply for the permission");
    }
}

