/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import com.hjq.permissions.AndroidManifestInfo;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionDescription;
import com.hjq.permissions.OnPermissionInterceptor;
import com.hjq.permissions.OnPermissionPageCallback;
import com.hjq.permissions.PermissionActivityIntentHandler;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionChecker;
import com.hjq.permissions.PermissionFragmentFactory;
import com.hjq.permissions.PermissionFragmentFactoryByApp;
import com.hjq.permissions.PermissionFragmentFactoryBySupport;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionType;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.List;

public final class XXPermissions {
    public static final int REQUEST_CODE = 1025;
    private static OnPermissionInterceptor sPermissionInterceptor;
    private static Class<? extends OnPermissionDescription> sPermissionDescriptionClass;
    private static Boolean sCheckMode;
    @NonNull
    private final List<String> mPermissions = new ArrayList<String>();
    @Nullable
    private Context mContext;
    @Nullable
    private Fragment mAppFragment;
    @Nullable
    private android.support.v4.app.Fragment mSupportFragment;
    @Nullable
    private OnPermissionInterceptor mPermissionInterceptor;
    @Nullable
    private OnPermissionDescription mPermissionDescription;
    @Nullable
    private Boolean mCheckMode;

    public static XXPermissions with(@NonNull Context context) {
        return new XXPermissions(context);
    }

    public static XXPermissions with(@NonNull Fragment appFragment) {
        return new XXPermissions(appFragment);
    }

    public static XXPermissions with(@NonNull android.support.v4.app.Fragment supportFragment) {
        return new XXPermissions(supportFragment);
    }

    public static void setCheckMode(boolean checkMode) {
        sCheckMode = checkMode;
    }

    public static void setPermissionInterceptor(OnPermissionInterceptor permissionInterceptor) {
        sPermissionInterceptor = permissionInterceptor;
    }

    @NonNull
    public static OnPermissionInterceptor getPermissionInterceptor() {
        if (sPermissionInterceptor == null) {
            sPermissionInterceptor = new OnPermissionInterceptor(){};
        }
        return sPermissionInterceptor;
    }

    public static void setPermissionDescription(Class<? extends OnPermissionDescription> permissionDescriptionClass) {
        sPermissionDescriptionClass = permissionDescriptionClass;
    }

    @NonNull
    public static OnPermissionDescription getPermissionDescription() {
        OnPermissionDescription permissionDescription = null;
        if (sPermissionDescriptionClass != null) {
            try {
                permissionDescription = sPermissionDescriptionClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (permissionDescription == null) {
            permissionDescription = new OnPermissionDescription(){

                @Override
                public void onRequestPermissionStart(@NonNull Activity activity, @NonNull List<String> requestPermissions) {
                }

                @Override
                public void onRequestPermissionEnd(@NonNull Activity activity, @NonNull List<String> requestPermissions) {
                }
            };
        }
        return permissionDescription;
    }

    private XXPermissions(@Nullable Context context) {
        this.mContext = context;
    }

    private XXPermissions(@Nullable Fragment appFragment) {
        this.mAppFragment = appFragment;
        if (appFragment == null) {
            return;
        }
        this.mContext = appFragment.getActivity();
    }

    private XXPermissions(@Nullable android.support.v4.app.Fragment supportFragment) {
        this.mSupportFragment = supportFragment;
        if (supportFragment == null) {
            return;
        }
        this.mContext = supportFragment.getActivity();
    }

    public XXPermissions permission(@Nullable String permission2) {
        if (permission2 == null) {
            return this;
        }
        if (PermissionUtils.containsPermission(this.mPermissions, permission2)) {
            return this;
        }
        this.mPermissions.add(permission2);
        return this;
    }

    public XXPermissions permission(String ... permissions) {
        return this.permission(PermissionUtils.asArrayList(permissions));
    }

    public XXPermissions permission(String[] ... permissions) {
        return this.permission(PermissionUtils.asArrayLists(permissions));
    }

    public XXPermissions permission(@Nullable List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return this;
        }
        for (String permission2 : permissions) {
            if (PermissionUtils.containsPermission(this.mPermissions, permission2)) continue;
            this.mPermissions.add(permission2);
        }
        return this;
    }

    public XXPermissions interceptor(@Nullable OnPermissionInterceptor permissionInterceptor) {
        this.mPermissionInterceptor = permissionInterceptor;
        return this;
    }

    public XXPermissions description(@Nullable OnPermissionDescription permissionDescription) {
        this.mPermissionDescription = permissionDescription;
        return this;
    }

    public XXPermissions unchecked() {
        this.mCheckMode = false;
        return this;
    }

    public void request(@Nullable OnPermissionCallback callback) {
        if (this.mContext == null) {
            return;
        }
        if (this.mPermissionInterceptor == null) {
            this.mPermissionInterceptor = XXPermissions.getPermissionInterceptor();
        }
        if (this.mPermissionDescription == null) {
            this.mPermissionDescription = XXPermissions.getPermissionDescription();
        }
        Context context = this.mContext;
        Fragment appFragment = this.mAppFragment;
        android.support.v4.app.Fragment supportFragment = this.mSupportFragment;
        OnPermissionInterceptor permissionInterceptor = this.mPermissionInterceptor;
        OnPermissionDescription permissionDescription = this.mPermissionDescription;
        ArrayList<String> permissions = new ArrayList<String>(this.mPermissions);
        Activity activity = PermissionUtils.findActivity(context);
        if (this.isCheckMode(context)) {
            PermissionChecker.checkActivityStatus(activity);
            if (appFragment != null) {
                PermissionChecker.checkAppFragmentStatus(appFragment);
            } else if (supportFragment != null) {
                PermissionChecker.checkSupportFragmentStatus(supportFragment);
            }
            PermissionChecker.checkPermissionList(permissions);
            AndroidManifestInfo androidManifestInfo = PermissionUtils.getAndroidManifestInfo(context);
            PermissionChecker.checkMediaLocationPermission(context, permissions);
            PermissionChecker.checkStoragePermission(context, permissions, androidManifestInfo);
            PermissionChecker.checkBodySensorsPermission(permissions);
            PermissionChecker.checkLocationPermission(permissions);
            PermissionChecker.checkPictureInPicturePermission(activity, permissions, androidManifestInfo);
            PermissionChecker.checkNotificationListenerPermission(permissions, androidManifestInfo);
            PermissionChecker.checkNearbyDevicesPermission(permissions, androidManifestInfo);
            PermissionChecker.checkReadMediaVisualUserSelectedPermission(permissions);
            PermissionChecker.checkGetInstallAppsPermission(context, permissions, androidManifestInfo);
            PermissionChecker.checkTargetSdkVersion(context, permissions);
            PermissionChecker.checkManifestPermissions(context, permissions, androidManifestInfo);
        }
        PermissionApi.addOldPermissionsByNewPermissions(permissions);
        PermissionApi.adjustPermissionsSort(permissions);
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        if (PermissionApi.isGrantedPermissions(context, permissions)) {
            permissionInterceptor.grantedPermissionRequest(activity, permissions, permissions, true, callback);
            permissionInterceptor.finishPermissionRequest(activity, permissions, true, callback);
            return;
        }
        if (appFragment != null && PermissionUtils.isFragmentUnavailable(appFragment)) {
            return;
        }
        if (supportFragment != null && PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity, supportFragment, appFragment);
        permissionInterceptor.launchPermissionRequest(activity, permissions, fragmentFactory, permissionDescription, callback);
    }

    public boolean revokeOnKill() {
        Context context = this.mContext;
        if (context == null) {
            return false;
        }
        List<String> permissions = this.mPermissions;
        if (permissions.isEmpty()) {
            return false;
        }
        if (!AndroidVersionTools.isAndroid13()) {
            return false;
        }
        try {
            if (permissions.size() == 1) {
                context.revokeSelfPermissionOnKill(permissions.get(0));
            } else {
                context.revokeSelfPermissionsOnKill(permissions);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            if (this.isCheckMode(context)) {
                throw e;
            }
            e.printStackTrace();
            return false;
        }
    }

    private boolean isCheckMode(@NonNull Context context) {
        if (this.mCheckMode == null) {
            if (sCheckMode == null) {
                sCheckMode = PermissionUtils.isDebugMode(context);
            }
            this.mCheckMode = sCheckMode;
        }
        return this.mCheckMode;
    }

    public static boolean isGrantedPermissions(@NonNull Context context, String ... permissions) {
        return XXPermissions.isGrantedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isGrantedPermissions(@NonNull Context context, String[] ... permissions) {
        return XXPermissions.isGrantedPermissions(context, PermissionUtils.asArrayLists(permissions));
    }

    public static boolean isGrantedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        return PermissionApi.isGrantedPermissions(context, permissions);
    }

    public static List<String> getGrantedPermissions(@NonNull Context context, String ... permissions) {
        return XXPermissions.getGrantedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static List<String> getGrantedPermissions(@NonNull Context context, String[] ... permissions) {
        return XXPermissions.getGrantedPermissions(context, PermissionUtils.asArrayLists(permissions));
    }

    public static List<String> getGrantedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        return PermissionApi.getGrantedPermissions(context, permissions);
    }

    public static List<String> getDeniedPermissions(@NonNull Context context, String ... permissions) {
        return XXPermissions.getDeniedPermissions(context, PermissionUtils.asArrayList(permissions));
    }

    public static List<String> getDeniedPermissions(@NonNull Context context, String[] ... permissions) {
        return XXPermissions.getDeniedPermissions(context, PermissionUtils.asArrayLists(permissions));
    }

    public static List<String> getDeniedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        return PermissionApi.getDeniedPermissions(context, permissions);
    }

    public static boolean isSpecialPermission(@NonNull String permission2) {
        return PermissionApi.isSpecialPermission(permission2);
    }

    public static boolean containsSpecialPermission(String ... permissions) {
        return XXPermissions.containsSpecialPermission(PermissionUtils.asArrayList(permissions));
    }

    public static boolean containsSpecialPermission(@NonNull List<String> permissions) {
        return PermissionApi.containsSpecialPermission(permissions);
    }

    public static boolean isBackgroundPermission(@NonNull String permission2) {
        return PermissionApi.isBackgroundPermission(permission2);
    }

    public static boolean containsBackgroundPermission(String ... permissions) {
        return XXPermissions.containsBackgroundPermission(PermissionUtils.asArrayList(permissions));
    }

    public static boolean containsBackgroundPermission(@NonNull List<String> permissions) {
        return PermissionApi.containsBackgroundPermission(permissions);
    }

    public static boolean isDoNotAskAgainPermissions(@NonNull Activity activity, String ... permissions) {
        return XXPermissions.isDoNotAskAgainPermissions(activity, PermissionUtils.asArrayList(permissions));
    }

    public static boolean isDoNotAskAgainPermissions(@NonNull Activity activity, String[] ... permissions) {
        return XXPermissions.isDoNotAskAgainPermissions(activity, PermissionUtils.asArrayLists(permissions));
    }

    public static boolean isDoNotAskAgainPermissions(@NonNull Activity activity, @NonNull List<String> permissions) {
        return PermissionApi.isDoNotAskAgainPermissions(activity, permissions);
    }

    public static boolean isHighVersionPermission(@NonNull String permission2) {
        return PermissionHelper.findAndroidVersionByPermission(permission2) > AndroidVersionTools.getCurrentAndroidVersionCode();
    }

    public static void startPermissionActivity(@NonNull Context context) {
        XXPermissions.startPermissionActivity(context, new ArrayList<String>(0));
    }

    public static void startPermissionActivity(@NonNull Context context, String ... permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Context context, String[] ... permissions) {
        XXPermissions.startPermissionActivity(context, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(@NonNull Context context, @NonNull List<String> permissions) {
        Activity activity = PermissionUtils.findActivity(context);
        if (activity != null) {
            XXPermissions.startPermissionActivity(activity, permissions);
            return;
        }
        Intent intent = PermissionApi.getBestPermissionSettingIntent(context, permissions);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        PermissionActivityIntentHandler.startActivity(context, intent);
    }

    public static void startPermissionActivity(@NonNull Activity activity) {
        XXPermissions.startPermissionActivity(activity, new ArrayList<String>(0));
    }

    public static void startPermissionActivity(@NonNull Activity activity, String ... permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Activity activity, String[] ... permissions) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<String> permissions) {
        XXPermissions.startPermissionActivity(activity, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<String> permissions, int requestCode) {
        Intent intent = PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions);
        PermissionActivityIntentHandler.startActivityForResult(activity, intent, requestCode);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull String permission2, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayList(permission2), callback);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull String[] permissions, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(activity, PermissionUtils.asArrayLists(new String[][]{permissions}), callback);
    }

    public static void startPermissionActivity(@NonNull Activity activity, @NonNull List<String> permissions, @Nullable OnPermissionPageCallback callback) {
        if (PermissionUtils.isActivityUnavailable(activity)) {
            return;
        }
        if (permissions.isEmpty()) {
            PermissionActivityIntentHandler.startActivity(activity, PermissionIntentManager.getApplicationDetailsIntent((Context)activity));
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity);
        fragmentFactory.createAndCommitFragment(permissions, PermissionType.SPECIAL, () -> {
            if (PermissionUtils.isActivityUnavailable(activity)) {
                return;
            }
            XXPermissions.dispatchPermissionPageCallback((Context)activity, permissions, callback);
        });
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment) {
        XXPermissions.startPermissionActivity(appFragment, new ArrayList<String>(0));
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, String ... permissions) {
        XXPermissions.startPermissionActivity(appFragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, String[] ... permissions) {
        XXPermissions.startPermissionActivity(appFragment, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, @NonNull List<String> permissions) {
        XXPermissions.startPermissionActivity(appFragment, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, @NonNull List<String> permissions, int requestCode) {
        if (PermissionUtils.isFragmentUnavailable(appFragment)) {
            return;
        }
        Activity activity = appFragment.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(appFragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            PermissionActivityIntentHandler.startActivity(appFragment, PermissionIntentManager.getApplicationDetailsIntent((Context)activity));
            return;
        }
        Intent intent = PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions);
        PermissionActivityIntentHandler.startActivityForResult(appFragment, intent, requestCode);
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, @NonNull String permission2, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(appFragment, PermissionUtils.asArrayList(permission2), callback);
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, @NonNull String[] permissions, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(appFragment, PermissionUtils.asArrayLists(new String[][]{permissions}), callback);
    }

    public static void startPermissionActivity(@NonNull Fragment appFragment, @NonNull List<String> permissions, @Nullable OnPermissionPageCallback callback) {
        if (PermissionUtils.isFragmentUnavailable(appFragment)) {
            return;
        }
        Activity activity = appFragment.getActivity();
        if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(appFragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            PermissionActivityIntentHandler.startActivity(appFragment, PermissionIntentManager.getApplicationDetailsIntent((Context)activity));
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory(activity, appFragment);
        fragmentFactory.createAndCommitFragment(permissions, PermissionType.SPECIAL, () -> {
            if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(appFragment)) {
                return;
            }
            XXPermissions.dispatchPermissionPageCallback((Context)activity, permissions, callback);
        });
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment) {
        XXPermissions.startPermissionActivity(supportFragment, new ArrayList<String>());
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, String ... permissions) {
        XXPermissions.startPermissionActivity(supportFragment, PermissionUtils.asArrayList(permissions));
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, String[] ... permissions) {
        XXPermissions.startPermissionActivity(supportFragment, PermissionUtils.asArrayLists(permissions));
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, @NonNull List<String> permissions) {
        XXPermissions.startPermissionActivity(supportFragment, permissions, 1025);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, @NonNull List<String> permissions, int requestCode) {
        if (PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        FragmentActivity activity = supportFragment.getActivity();
        if (PermissionUtils.isActivityUnavailable((Activity)activity) || PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            PermissionActivityIntentHandler.startActivity(supportFragment, PermissionIntentManager.getApplicationDetailsIntent((Context)activity));
            return;
        }
        Intent intent = PermissionApi.getBestPermissionSettingIntent((Context)activity, permissions);
        PermissionActivityIntentHandler.startActivityForResult(supportFragment, intent, requestCode);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, @NonNull String permission2, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(supportFragment, PermissionUtils.asArrayList(permission2), callback);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, @NonNull String[] permissions, @Nullable OnPermissionPageCallback callback) {
        XXPermissions.startPermissionActivity(supportFragment, PermissionUtils.asArrayLists(new String[][]{permissions}), callback);
    }

    public static void startPermissionActivity(@NonNull android.support.v4.app.Fragment supportFragment, @NonNull List<String> permissions, @Nullable OnPermissionPageCallback callback) {
        if (PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        FragmentActivity activity = supportFragment.getActivity();
        if (PermissionUtils.isActivityUnavailable((Activity)activity) || PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        if (permissions.isEmpty()) {
            PermissionActivityIntentHandler.startActivity(supportFragment, PermissionIntentManager.getApplicationDetailsIntent((Context)activity));
            return;
        }
        PermissionFragmentFactory<?, ?> fragmentFactory = XXPermissions.generatePermissionFragmentFactory((Activity)activity, supportFragment);
        fragmentFactory.createAndCommitFragment(permissions, PermissionType.SPECIAL, () -> XXPermissions.lambda$startPermissionActivity$2((Activity)activity, supportFragment, permissions, callback));
    }

    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity) {
        return XXPermissions.generatePermissionFragmentFactory(activity, null, null);
    }

    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity, @Nullable android.support.v4.app.Fragment supportFragment) {
        return XXPermissions.generatePermissionFragmentFactory(activity, supportFragment, null);
    }

    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity, @Nullable Fragment appFragment) {
        return XXPermissions.generatePermissionFragmentFactory(activity, null, appFragment);
    }

    private static PermissionFragmentFactory<?, ?> generatePermissionFragmentFactory(@NonNull Activity activity, @Nullable android.support.v4.app.Fragment supportFragment, @Nullable Fragment appFragment) {
        PermissionFragmentFactory fragmentFactory;
        if (supportFragment != null) {
            fragmentFactory = new PermissionFragmentFactoryBySupport(supportFragment.getActivity(), supportFragment.getChildFragmentManager());
        } else if (appFragment != null) {
            fragmentFactory = new PermissionFragmentFactoryByApp(appFragment.getActivity(), appFragment.getChildFragmentManager());
        } else if (activity instanceof FragmentActivity) {
            FragmentActivity fragmentActivity = (FragmentActivity)activity;
            fragmentFactory = new PermissionFragmentFactoryBySupport(fragmentActivity, fragmentActivity.getSupportFragmentManager());
        } else {
            fragmentFactory = new PermissionFragmentFactoryByApp(activity, activity.getFragmentManager());
        }
        return fragmentFactory;
    }

    private static void dispatchPermissionPageCallback(@NonNull Context context, @NonNull List<String> permissions, @Nullable OnPermissionPageCallback callback) {
        if (callback == null) {
            return;
        }
        if (XXPermissions.isGrantedPermissions(context, permissions)) {
            callback.onGranted();
        } else {
            callback.onDenied();
        }
    }

    private static /* synthetic */ void lambda$startPermissionActivity$2(Activity activity, android.support.v4.app.Fragment supportFragment, List permissions, OnPermissionPageCallback callback) {
        if (PermissionUtils.isActivityUnavailable(activity) || PermissionUtils.isFragmentUnavailable(supportFragment)) {
            return;
        }
        XXPermissions.dispatchPermissionPageCallback((Context)activity, permissions, callback);
    }
}

