/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.permissions.AndroidManifestInfo;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.Permission;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

final class PermissionChecker {
    PermissionChecker() {
    }

    static void checkActivityStatus(@Nullable Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("The instance of the context must be an activity object");
        }
        if (activity.isFinishing()) {
            throw new IllegalStateException("The activity has been finishing, please manually determine the status of the activity");
        }
        if (activity.isDestroyed()) {
            throw new IllegalStateException("The activity has been destroyed, please manually determine the status of the activity");
        }
    }

    static void checkSupportFragmentStatus(@NonNull android.support.v4.app.Fragment supportFragment) {
        if (!supportFragment.isAdded()) {
            throw new IllegalStateException("This support fragment has no binding added, please manually determine the status of the support fragment");
        }
        if (supportFragment.isRemoving()) {
            throw new IllegalStateException("This support fragment has been removed, please manually determine the status of the support fragment");
        }
    }

    static void checkAppFragmentStatus(@NonNull Fragment appFragment) {
        if (!appFragment.isAdded()) {
            throw new IllegalStateException("This app fragment has no binding added, please manually determine the status of the app fragment");
        }
        if (appFragment.isRemoving()) {
            throw new IllegalStateException("This app fragment has been removed, please manually determine the status of the app fragment");
        }
    }

    static void checkPermissionList(@Nullable List<String> requestPermissions) {
        if (requestPermissions == null || requestPermissions.isEmpty()) {
            throw new IllegalArgumentException("The requested permission cannot be empty");
        }
        if (AndroidVersionTools.getCurrentAndroidVersionCode() > AndroidVersionTools.getLatestAdaptationAndroidVersionCode()) {
            return;
        }
        ArrayList<String> permissions = new ArrayList<String>();
        Field[] fields = Permission.class.getDeclaredFields();
        if (fields.length == 0) {
            return;
        }
        for (Field field : fields) {
            if (!String.class.equals(field.getType())) continue;
            try {
                permissions.add((String)field.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (String permission2 : requestPermissions) {
            if (PermissionUtils.containsPermission(permissions, permission2)) continue;
            throw new IllegalArgumentException("The " + permission2 + " is not a dangerous permission or special permission, please do not request dynamically");
        }
    }

    static void checkMediaLocationPermission(@NonNull Context context, @NonNull List<String> requestPermissions) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return;
        }
        if (AndroidVersionTools.getTargetSdkVersionCode(context) >= 33) {
            if (!(PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE"))) {
                throw new IllegalArgumentException("You must add android.permission.READ_MEDIA_IMAGES or android.permission.READ_MEDIA_VIDEO or android.permission.MANAGE_EXTERNAL_STORAGE rights to apply for android.permission.ACCESS_MEDIA_LOCATION rights");
            }
        } else if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
            throw new IllegalArgumentException("You must add android.permission.READ_EXTERNAL_STORAGE or android.permission.MANAGE_EXTERNAL_STORAGE rights to apply for android.permission.ACCESS_MEDIA_LOCATION rights");
        }
    }

    static void checkStoragePermission(@NonNull Context context, @NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (!(PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_AUDIO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.WRITE_EXTERNAL_STORAGE"))) {
            return;
        }
        if (AndroidVersionTools.getTargetSdkVersionCode(context) >= 33 && PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE")) {
            throw new IllegalArgumentException("When targetSdkVersion >= 33 should use android.permission.READ_MEDIA_IMAGES, android.permission.READ_MEDIA_VIDEO, android.permission.READ_MEDIA_AUDIO, rather than android.permission.READ_EXTERNAL_STORAGE");
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_AUDIO")) {
            if (PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE")) {
                throw new IllegalArgumentException("If you have applied for media permissions, do not apply for the READ_EXTERNAL_STORAGE and WRITE_EXTERNAL_STORAGE permissions");
            }
            if (PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
                throw new IllegalArgumentException("Because the MANAGE_EXTERNAL_STORAGE permission range is very large, you can read media files with it, and there is no need to apply for additional media permissions.");
            }
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") && (PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_EXTERNAL_STORAGE") || PermissionUtils.containsPermission(requestPermissions, "android.permission.WRITE_EXTERNAL_STORAGE"))) {
            throw new IllegalArgumentException("If you have applied for MANAGE_EXTERNAL_STORAGE permissions, do not apply for the READ_EXTERNAL_STORAGE and WRITE_EXTERNAL_STORAGE permissions");
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_MEDIA_LOCATION")) {
            return;
        }
        if (androidManifestInfo == null) {
            return;
        }
        AndroidManifestInfo.ApplicationInfo applicationInfo = androidManifestInfo.applicationInfo;
        if (applicationInfo == null) {
            return;
        }
        boolean scopedStorage = PermissionUtils.isScopedStorage(context);
        int targetSdkVersion = AndroidVersionTools.getTargetSdkVersionCode(context);
        boolean requestLegacyExternalStorage = applicationInfo.requestLegacyExternalStorage;
        if (!(targetSdkVersion < 29 || requestLegacyExternalStorage || !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") && scopedStorage)) {
            throw new IllegalStateException("Please register the android:requestLegacyExternalStorage=\"true\" attribute in the AndroidManifest.xml file, otherwise it will cause incompatibility with the old version");
        }
        if (targetSdkVersion >= 30 && !PermissionUtils.containsPermission(requestPermissions, "android.permission.MANAGE_EXTERNAL_STORAGE") && !scopedStorage) {
            throw new IllegalArgumentException("The storage permission application is abnormal. If you have adapted the scope storage, please register the <meta-data android:name=\"ScopedStorage\" android:value=\"true\" /> attribute in the AndroidManifest.xml file. If there is no adaptation scope storage, please use android.permission.MANAGE_EXTERNAL_STORAGE to apply for permission");
        }
    }

    static void checkBodySensorsPermission(@NonNull List<String> requestPermissions) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS_BACKGROUND")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS_BACKGROUND") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.BODY_SENSORS")) {
            throw new IllegalArgumentException("Applying for background sensor permissions must contain android.permission.BODY_SENSORS");
        }
    }

    static void checkLocationPermission(@NonNull List<String> requestPermissions) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_COARSE_LOCATION") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
            throw new IllegalArgumentException("Applying for background positioning permissions must include android.permission.ACCESS_FINE_LOCATION");
        }
    }

    static void checkNearbyDevicesPermission(@NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.BLUETOOTH_SCAN") && !PermissionUtils.containsPermission(requestPermissions, "android.permission.NEARBY_WIFI_DEVICES")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.ACCESS_FINE_LOCATION")) {
            return;
        }
        if (androidManifestInfo == null) {
            return;
        }
        List<AndroidManifestInfo.PermissionInfo> permissionInfoList = androidManifestInfo.permissionInfoList;
        for (AndroidManifestInfo.PermissionInfo permissionInfo : permissionInfoList) {
            if (!PermissionUtils.equalsPermission(permissionInfo.name, "android.permission.BLUETOOTH_SCAN") && !PermissionUtils.equalsPermission(permissionInfo.name, "android.permission.NEARBY_WIFI_DEVICES") || permissionInfo.neverForLocation()) continue;
            String maxSdkVersionString = permissionInfo.maxSdkVersion != Integer.MAX_VALUE ? "android:maxSdkVersion=\"" + permissionInfo.maxSdkVersion + "\" " : "";
            throw new IllegalArgumentException("If your app doesn't use " + permissionInfo.name + " to get physical location, please change the <uses-permission android:name=\"" + permissionInfo.name + "\" " + maxSdkVersionString + "/> node in the manifest file to <uses-permission android:name=\"" + permissionInfo.name + "\" android:usesPermissionFlags=\"neverForLocation\" " + maxSdkVersionString + "/> node, if your app need use " + permissionInfo.name + " to get physical location, also need to add " + "android.permission.ACCESS_FINE_LOCATION" + " permissions");
        }
    }

    static void checkNotificationListenerPermission(@NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE")) {
            return;
        }
        if (androidManifestInfo == null) {
            return;
        }
        List<AndroidManifestInfo.ServiceInfo> serviceInfoList = androidManifestInfo.serviceInfoList;
        for (int i = 0; i < serviceInfoList.size(); ++i) {
            String permission2 = serviceInfoList.get((int)i).permission;
            if (!TextUtils.equals((CharSequence)permission2, (CharSequence)"android.permission.BIND_NOTIFICATION_LISTENER_SERVICE")) continue;
            return;
        }
        throw new IllegalArgumentException("No service registered permission attribute, please register <service android:permission=\"android.permission.BIND_NOTIFICATION_LISTENER_SERVICE\" > in AndroidManifest.xml");
    }

    static void checkPictureInPicturePermission(@NonNull Activity activity, @NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.PICTURE_IN_PICTURE")) {
            return;
        }
        if (androidManifestInfo == null) {
            return;
        }
        List<AndroidManifestInfo.ActivityInfo> activityInfoList = androidManifestInfo.activityInfoList;
        for (int i = 0; i < activityInfoList.size(); ++i) {
            boolean supportsPictureInPicture = activityInfoList.get((int)i).supportsPictureInPicture;
            if (!supportsPictureInPicture) continue;
            return;
        }
        String activityName = activity.getClass().getName().replace(activity.getPackageName(), "");
        throw new IllegalArgumentException("No activity registered supportsPictureInPicture attribute, please register \n<activity android:name=\"" + activityName + "\" android:supportsPictureInPicture=\"true\" > in AndroidManifest.xml");
    }

    static void checkReadMediaVisualUserSelectedPermission(@NonNull List<String> requestPermissions) {
        if (!PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VISUAL_USER_SELECTED")) {
            return;
        }
        if (PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.containsPermission(requestPermissions, "android.permission.READ_MEDIA_VIDEO")) {
            return;
        }
        throw new IllegalArgumentException("You cannot request the android.permission.READ_MEDIA_VISUAL_USER_SELECTED permission alone. must add either android.permission.READ_MEDIA_IMAGES or android.permission.READ_MEDIA_VIDEO permission, or maybe both");
    }

    static void checkGetInstallAppsPermission(@NonNull Context context, @NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (androidManifestInfo == null) {
            return;
        }
        if (!PermissionUtils.containsPermission(requestPermissions, "com.android.permission.GET_INSTALLED_APPS")) {
            return;
        }
        if (AndroidVersionTools.getTargetSdkVersionCode(context) < 30) {
            return;
        }
        String queryAllPackagesPermissionName = AndroidVersionTools.isAndroid11() ? "android.permission.QUERY_ALL_PACKAGES" : "android.permission.QUERY_ALL_PACKAGES";
        AndroidManifestInfo.PermissionInfo permissionInfo = PermissionChecker.findPermissionInfoByList(androidManifestInfo.permissionInfoList, queryAllPackagesPermissionName);
        if (permissionInfo != null || !androidManifestInfo.queriesPackageList.isEmpty()) {
            return;
        }
        throw new IllegalStateException("Please register permissions in the AndroidManifest.xml file <uses-permission android:name=\"" + queryAllPackagesPermissionName + "\" />, or add the app package name to the <queries> tag in the AndroidManifest.xml file");
    }

    static void checkTargetSdkVersion(@NonNull Context context, @NonNull List<String> requestPermissions) {
        for (String permission2 : requestPermissions) {
            int targetSdkMinVersion = PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_VISUAL_USER_SELECTED") ? 33 : (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN") || PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_CONNECT") || PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_ADVERTISE") ? 23 : PermissionHelper.findAndroidVersionByPermission(permission2));
            if (AndroidVersionTools.getTargetSdkVersionCode(context) >= targetSdkMinVersion) continue;
            throw new IllegalStateException("Request " + permission2 + " permission, The targetSdkVersion SDK must be " + targetSdkMinVersion + " or more, if you do not want to upgrade targetSdkVersion, please apply with the old permission");
        }
    }

    static void checkManifestPermissions(@NonNull Context context, @NonNull List<String> requestPermissions, @Nullable AndroidManifestInfo androidManifestInfo) {
        if (androidManifestInfo == null) {
            return;
        }
        List<AndroidManifestInfo.PermissionInfo> permissionInfoList = androidManifestInfo.permissionInfoList;
        if (permissionInfoList.isEmpty()) {
            throw new IllegalStateException("No permissions are registered in the AndroidManifest.xml file");
        }
        int minSdkVersion = AndroidVersionTools.isAndroid7() ? context.getApplicationInfo().minSdkVersion : (androidManifestInfo.usesSdkInfo != null ? androidManifestInfo.usesSdkInfo.minSdkVersion : 17);
        for (String permission2 : requestPermissions) {
            if (PermissionHelper.isVirtualPermission(permission2)) continue;
            if (PermissionUtils.equalsPermission(permission2, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                PermissionChecker.checkWriteExternalStoragePermission(context, androidManifestInfo.applicationInfo, permissionInfoList);
            } else {
                PermissionChecker.checkManifestPermission(permissionInfoList, permission2);
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.BODY_SENSORS_BACKGROUND")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.BODY_SENSORS");
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
                if (AndroidVersionTools.getTargetSdkVersionCode(context) >= 31) {
                    PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.ACCESS_FINE_LOCATION", 30);
                    PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.ACCESS_COARSE_LOCATION");
                    continue;
                }
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.ACCESS_FINE_LOCATION");
                continue;
            }
            if (minSdkVersion >= PermissionHelper.findAndroidVersionByPermission(permission2)) {
                return;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_IMAGES") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_VIDEO") || PermissionUtils.equalsPermission(permission2, "android.permission.READ_MEDIA_AUDIO")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.READ_EXTERNAL_STORAGE", 32);
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.NEARBY_WIFI_DEVICES")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.ACCESS_FINE_LOCATION", 32);
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_SCAN")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.BLUETOOTH_ADMIN", 30);
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.ACCESS_FINE_LOCATION", 30);
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_CONNECT")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.BLUETOOTH", 30);
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.BLUETOOTH_ADVERTISE")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.BLUETOOTH_ADMIN", 30);
                continue;
            }
            if (PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) {
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.READ_EXTERNAL_STORAGE", 29);
                PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.WRITE_EXTERNAL_STORAGE", 29);
                continue;
            }
            if (!PermissionUtils.equalsPermission(permission2, "android.permission.READ_PHONE_NUMBERS")) continue;
            PermissionChecker.checkManifestPermission(permissionInfoList, "android.permission.READ_PHONE_STATE", 25);
        }
    }

    static void checkWriteExternalStoragePermission(@NonNull Context context, @Nullable AndroidManifestInfo.ApplicationInfo applicationInfo, @NonNull List<AndroidManifestInfo.PermissionInfo> permissionInfoList) {
        if (applicationInfo == null) {
            return;
        }
        String checkPermission = "android.permission.WRITE_EXTERNAL_STORAGE";
        if (AndroidVersionTools.getTargetSdkVersionCode(context) < 29) {
            PermissionChecker.checkManifestPermission(permissionInfoList, checkPermission);
            return;
        }
        if (AndroidVersionTools.getTargetSdkVersionCode(context) >= 30 && PermissionChecker.findPermissionInfoByList(permissionInfoList, "android.permission.MANAGE_EXTERNAL_STORAGE") != null) {
            PermissionChecker.checkManifestPermission(permissionInfoList, checkPermission, 29);
            return;
        }
        if (applicationInfo.requestLegacyExternalStorage) {
            PermissionChecker.checkManifestPermission(permissionInfoList, checkPermission, 29);
        } else {
            PermissionChecker.checkManifestPermission(permissionInfoList, checkPermission, 28);
        }
    }

    static void checkManifestPermission(@NonNull List<AndroidManifestInfo.PermissionInfo> permissionInfoList, @NonNull String checkPermission) {
        PermissionChecker.checkManifestPermission(permissionInfoList, checkPermission, Integer.MAX_VALUE);
    }

    static void checkManifestPermission(@NonNull List<AndroidManifestInfo.PermissionInfo> permissionInfoList, @NonNull String checkPermission, int lowestMaxSdkVersion) {
        AndroidManifestInfo.PermissionInfo permissionInfo = PermissionChecker.findPermissionInfoByList(permissionInfoList, checkPermission);
        if (permissionInfo == null) {
            throw new IllegalStateException("Please register permissions in the AndroidManifest.xml file <uses-permission android:name=\"" + checkPermission + "\" />");
        }
        int manifestMaxSdkVersion = permissionInfo.maxSdkVersion;
        if (manifestMaxSdkVersion < lowestMaxSdkVersion) {
            throw new IllegalArgumentException("The AndroidManifest.xml file <uses-permission android:name=\"" + checkPermission + "\" android:maxSdkVersion=\"" + manifestMaxSdkVersion + "\" /> does not meet the requirements, " + (lowestMaxSdkVersion != Integer.MAX_VALUE ? "the minimum requirement for maxSdkVersion is " + lowestMaxSdkVersion : "please delete the android:maxSdkVersion=\"" + manifestMaxSdkVersion + "\" attribute"));
        }
    }

    @Nullable
    static AndroidManifestInfo.PermissionInfo findPermissionInfoByList(@NonNull List<AndroidManifestInfo.PermissionInfo> permissionInfoList, @NonNull String permissionName) {
        AndroidManifestInfo.PermissionInfo permissionInfo = null;
        for (AndroidManifestInfo.PermissionInfo info : permissionInfoList) {
            if (!TextUtils.equals((CharSequence)info.name, (CharSequence)permissionName)) continue;
            permissionInfo = info;
            break;
        }
        return permissionInfo;
    }
}

