/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.AndroidVersionTools;
import com.hjq.permissions.IPermissionDelegate;
import com.hjq.permissions.PermissionDelegateImplV34;
import com.hjq.permissions.PermissionHelper;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class PermissionApi {
    @NonNull
    private static final IPermissionDelegate DELEGATE = new PermissionDelegateImplV34();

    PermissionApi() {
    }

    static boolean isGrantedPermission(@NonNull Context context, @NonNull String permission) {
        return PermissionApi.isGrantedPermission(context, permission, true);
    }

    static boolean isGrantedPermission(@NonNull Context context, @NonNull String permission, boolean skipRequest) {
        return DELEGATE.isGrantedPermission(context, permission, skipRequest);
    }

    static boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission) {
        return DELEGATE.isDoNotAskAgainPermission(activity, permission);
    }

    static Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission) {
        return DELEGATE.getPermissionSettingIntent(context, permission);
    }

    static boolean isSpecialPermission(@NonNull String permission) {
        return PermissionHelper.isSpecialPermission(permission);
    }

    static boolean isBackgroundPermission(@NonNull String permission) {
        return PermissionHelper.isBackgroundPermission(permission);
    }

    static boolean containsSpecialPermission(@Nullable List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission : permissions) {
            if (!PermissionApi.isSpecialPermission(permission)) continue;
            return true;
        }
        return false;
    }

    static boolean containsBackgroundPermission(@Nullable List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (String permission : permissions) {
            if (!PermissionApi.isBackgroundPermission(permission)) continue;
            return true;
        }
        return false;
    }

    static boolean isGrantedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        if (permissions.isEmpty()) {
            return false;
        }
        for (String permission : permissions) {
            if (PermissionApi.isGrantedPermission(context, permission)) continue;
            return false;
        }
        return true;
    }

    static List<String> getGrantedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        ArrayList<String> grantedPermissions = new ArrayList<String>(permissions.size());
        for (String permission : permissions) {
            if (!PermissionApi.isGrantedPermission(context, permission)) continue;
            grantedPermissions.add(permission);
        }
        return grantedPermissions;
    }

    static List<String> getDeniedPermissions(@NonNull Context context, @NonNull List<String> permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>(permissions.size());
        for (String permission : permissions) {
            if (PermissionApi.isGrantedPermission(context, permission)) continue;
            deniedPermissions.add(permission);
        }
        return deniedPermissions;
    }

    static boolean isDoNotAskAgainPermissions(@NonNull Activity activity, @NonNull List<String> permissions) {
        for (String permission : permissions) {
            if (!PermissionApi.isDoNotAskAgainPermission(activity, permission)) continue;
            return true;
        }
        return false;
    }

    static Intent getBestPermissionSettingIntent(@NonNull Context context, @Nullable List<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return PermissionIntentManager.getApplicationDetailsIntent(context);
        }
        ArrayList<String> realPermissions = new ArrayList<String>(permissions);
        for (String permission : permissions) {
            if (PermissionHelper.findAndroidVersionByPermission(permission) > AndroidVersionTools.getCurrentAndroidVersionCode()) {
                realPermissions.remove(permission);
                continue;
            }
            ArrayList<String> oldPermissions = PermissionUtils.asArrayList(PermissionHelper.queryOldPermissionByNewPermission(permission));
            if (oldPermissions.isEmpty() || !PermissionApi.isSpecialPermission(permission) && !PermissionApi.containsSpecialPermission(oldPermissions)) continue;
            realPermissions.removeAll(oldPermissions);
        }
        if (realPermissions.isEmpty()) {
            return PermissionIntentManager.getApplicationDetailsIntent(context);
        }
        if (realPermissions.size() == 1) {
            return PermissionApi.getPermissionSettingIntent(context, (String)realPermissions.get(0));
        }
        return PermissionIntentManager.getApplicationDetailsIntent(context, realPermissions);
    }

    static void addOldPermissionsByNewPermissions(@NonNull List<String> requestPermissions) {
        ArrayList<String> needSupplementPermissions = null;
        for (String permission : requestPermissions) {
            String[] oldPermissions;
            if (AndroidVersionTools.getCurrentAndroidVersionCode() >= PermissionHelper.findAndroidVersionByPermission(permission) || (oldPermissions = PermissionHelper.queryOldPermissionByNewPermission(permission)) == null) continue;
            for (String oldPermission : oldPermissions) {
                if (PermissionUtils.containsPermission(requestPermissions, oldPermission)) continue;
                if (needSupplementPermissions == null) {
                    needSupplementPermissions = new ArrayList<String>();
                }
                if (PermissionUtils.containsPermission((Collection<String>)needSupplementPermissions, oldPermission)) continue;
                needSupplementPermissions.add(oldPermission);
            }
        }
        if (needSupplementPermissions == null || needSupplementPermissions.isEmpty()) {
            return;
        }
        requestPermissions.addAll((Collection<String>)needSupplementPermissions);
    }

    static void adjustPermissionsSort(@NonNull List<String> requestPermissions) {
        List<String> lowLevelPermissions = PermissionHelper.getLowLevelPermissions();
        for (String lowLevelPermission : lowLevelPermissions) {
            if (!PermissionUtils.containsPermission(requestPermissions, lowLevelPermission)) continue;
            requestPermissions.remove(lowLevelPermission);
            requestPermissions.add(lowLevelPermission);
        }
    }

    static boolean areAllDangerousPermission(@NonNull List<String> permissions) {
        for (String permission : permissions) {
            if (!PermissionApi.isSpecialPermission(permission)) continue;
            return false;
        }
        return true;
    }
}

