/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.PermissionDelegateImplV23;
import com.hjq.permissions.PermissionUtils;

class PermissionDelegateImplV26
extends PermissionDelegateImplV23 {
    PermissionDelegateImplV26() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_INSTALL_PACKAGES")) {
            if (!AndroidVersion.isAndroid8()) {
                return true;
            }
            return PermissionDelegateImplV26.isGrantedInstallPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PICTURE_IN_PICTURE")) {
            if (!AndroidVersion.isAndroid8()) {
                return true;
            }
            return PermissionDelegateImplV26.isGrantedPictureInPicturePermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_PHONE_NUMBERS")) {
            if (!AndroidVersion.isAndroid6()) {
                return true;
            }
            if (!AndroidVersion.isAndroid8()) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.READ_PHONE_STATE");
            }
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ANSWER_PHONE_CALLS")) {
            if (!AndroidVersion.isAndroid8()) {
                return true;
            }
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_INSTALL_PACKAGES")) {
            return false;
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PICTURE_IN_PICTURE")) {
            return false;
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.READ_PHONE_NUMBERS")) {
            if (!AndroidVersion.isAndroid6()) {
                return false;
            }
            if (!AndroidVersion.isAndroid8()) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_PHONE_STATE") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_PHONE_STATE");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.ANSWER_PHONE_CALLS")) {
            if (!AndroidVersion.isAndroid8()) {
                return false;
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public Intent getPermissionSettingIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.REQUEST_INSTALL_PACKAGES")) {
            if (!AndroidVersion.isAndroid8()) {
                return PermissionDelegateImplV26.getApplicationDetailsIntent(context);
            }
            return PermissionDelegateImplV26.getInstallPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.PICTURE_IN_PICTURE")) {
            if (!AndroidVersion.isAndroid8()) {
                return PermissionDelegateImplV26.getApplicationDetailsIntent(context);
            }
            return PermissionDelegateImplV26.getPictureInPicturePermissionIntent(context);
        }
        return super.getPermissionSettingIntent(context, permission2);
    }

    @RequiresApi(value=26)
    private static boolean isGrantedInstallPermission(@NonNull Context context) {
        return context.getPackageManager().canRequestPackageInstalls();
    }

    @RequiresApi(value=26)
    private static Intent getInstallPermissionIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV26.getApplicationDetailsIntent(context);
        }
        return intent;
    }

    @RequiresApi(value=26)
    private static boolean isGrantedPictureInPicturePermission(@NonNull Context context) {
        return PermissionUtils.checkOpNoThrow(context, "android:picture_in_picture");
    }

    @RequiresApi(value=26)
    private static Intent getPictureInPicturePermissionIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.PICTURE_IN_PICTURE_SETTINGS");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionDelegateImplV26.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

