/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.support.annotation.NonNull;
import com.hjq.permissions.PermissionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class PermissionHelper {
    private static final List<String> SPECIAL_PERMISSION_LIST = new ArrayList<String>(12);
    private static final Map<String, Integer> PERMISSION_VERSION_MAP = new HashMap<String, Integer>(53);
    private static final List<String> VIRTUAL_PERMISSION_LIST = new ArrayList<String>(4);

    PermissionHelper() {
    }

    static boolean isSpecialPermission(@NonNull String permission2) {
        return PermissionUtils.containsPermission(SPECIAL_PERMISSION_LIST, permission2);
    }

    static int findAndroidVersionByPermission(@NonNull String permission2) {
        Integer androidVersion = PERMISSION_VERSION_MAP.get(permission2);
        if (androidVersion == null) {
            return 0;
        }
        return androidVersion;
    }

    static boolean isVirtualPermission(@NonNull String permission2) {
        return PermissionUtils.containsPermission(VIRTUAL_PERMISSION_LIST, permission2);
    }

    static {
        SPECIAL_PERMISSION_LIST.add("android.permission.SCHEDULE_EXACT_ALARM");
        SPECIAL_PERMISSION_LIST.add("android.permission.MANAGE_EXTERNAL_STORAGE");
        SPECIAL_PERMISSION_LIST.add("android.permission.REQUEST_INSTALL_PACKAGES");
        SPECIAL_PERMISSION_LIST.add("android.permission.PICTURE_IN_PICTURE");
        SPECIAL_PERMISSION_LIST.add("android.permission.SYSTEM_ALERT_WINDOW");
        SPECIAL_PERMISSION_LIST.add("android.permission.WRITE_SETTINGS");
        SPECIAL_PERMISSION_LIST.add("android.permission.ACCESS_NOTIFICATION_POLICY");
        SPECIAL_PERMISSION_LIST.add("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
        SPECIAL_PERMISSION_LIST.add("android.permission.PACKAGE_USAGE_STATS");
        SPECIAL_PERMISSION_LIST.add("android.permission.NOTIFICATION_SERVICE");
        SPECIAL_PERMISSION_LIST.add("android.permission.BIND_NOTIFICATION_LISTENER_SERVICE");
        SPECIAL_PERMISSION_LIST.add("android.permission.BIND_VPN_SERVICE");
        PERMISSION_VERSION_MAP.put("android.permission.SCHEDULE_EXACT_ALARM", 31);
        PERMISSION_VERSION_MAP.put("android.permission.MANAGE_EXTERNAL_STORAGE", 30);
        PERMISSION_VERSION_MAP.put("android.permission.REQUEST_INSTALL_PACKAGES", 26);
        PERMISSION_VERSION_MAP.put("android.permission.PICTURE_IN_PICTURE", 26);
        PERMISSION_VERSION_MAP.put("android.permission.SYSTEM_ALERT_WINDOW", 23);
        PERMISSION_VERSION_MAP.put("android.permission.WRITE_SETTINGS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.ACCESS_NOTIFICATION_POLICY", 23);
        PERMISSION_VERSION_MAP.put("android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.PACKAGE_USAGE_STATS", 21);
        PERMISSION_VERSION_MAP.put("android.permission.NOTIFICATION_SERVICE", 19);
        PERMISSION_VERSION_MAP.put("android.permission.BIND_NOTIFICATION_LISTENER_SERVICE", 18);
        PERMISSION_VERSION_MAP.put("android.permission.BIND_VPN_SERVICE", 14);
        PERMISSION_VERSION_MAP.put("android.permission.READ_MEDIA_VISUAL_USER_SELECTED", 34);
        PERMISSION_VERSION_MAP.put("android.permission.POST_NOTIFICATIONS", 33);
        PERMISSION_VERSION_MAP.put("android.permission.NEARBY_WIFI_DEVICES", 33);
        PERMISSION_VERSION_MAP.put("android.permission.BODY_SENSORS_BACKGROUND", 33);
        PERMISSION_VERSION_MAP.put("android.permission.READ_MEDIA_IMAGES", 33);
        PERMISSION_VERSION_MAP.put("android.permission.READ_MEDIA_VIDEO", 33);
        PERMISSION_VERSION_MAP.put("android.permission.READ_MEDIA_AUDIO", 33);
        PERMISSION_VERSION_MAP.put("android.permission.BLUETOOTH_SCAN", 31);
        PERMISSION_VERSION_MAP.put("android.permission.BLUETOOTH_CONNECT", 31);
        PERMISSION_VERSION_MAP.put("android.permission.BLUETOOTH_ADVERTISE", 31);
        PERMISSION_VERSION_MAP.put("android.permission.ACCESS_BACKGROUND_LOCATION", 29);
        PERMISSION_VERSION_MAP.put("android.permission.ACTIVITY_RECOGNITION", 29);
        PERMISSION_VERSION_MAP.put("android.permission.ACCESS_MEDIA_LOCATION", 29);
        PERMISSION_VERSION_MAP.put("android.permission.ACCEPT_HANDOVER", 28);
        PERMISSION_VERSION_MAP.put("android.permission.ANSWER_PHONE_CALLS", 26);
        PERMISSION_VERSION_MAP.put("android.permission.READ_PHONE_NUMBERS", 26);
        PERMISSION_VERSION_MAP.put("com.android.permission.GET_INSTALLED_APPS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_EXTERNAL_STORAGE", 23);
        PERMISSION_VERSION_MAP.put("android.permission.WRITE_EXTERNAL_STORAGE", 23);
        PERMISSION_VERSION_MAP.put("android.permission.CAMERA", 23);
        PERMISSION_VERSION_MAP.put("android.permission.RECORD_AUDIO", 23);
        PERMISSION_VERSION_MAP.put("android.permission.ACCESS_FINE_LOCATION", 23);
        PERMISSION_VERSION_MAP.put("android.permission.ACCESS_COARSE_LOCATION", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_CONTACTS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.WRITE_CONTACTS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.GET_ACCOUNTS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_CALENDAR", 23);
        PERMISSION_VERSION_MAP.put("android.permission.WRITE_CALENDAR", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_PHONE_STATE", 23);
        PERMISSION_VERSION_MAP.put("android.permission.CALL_PHONE", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_CALL_LOG", 23);
        PERMISSION_VERSION_MAP.put("android.permission.WRITE_CALL_LOG", 23);
        PERMISSION_VERSION_MAP.put("com.android.voicemail.permission.ADD_VOICEMAIL", 23);
        PERMISSION_VERSION_MAP.put("android.permission.USE_SIP", 23);
        PERMISSION_VERSION_MAP.put("android.permission.PROCESS_OUTGOING_CALLS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.BODY_SENSORS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.SEND_SMS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.RECEIVE_SMS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.READ_SMS", 23);
        PERMISSION_VERSION_MAP.put("android.permission.RECEIVE_WAP_PUSH", 23);
        PERMISSION_VERSION_MAP.put("android.permission.RECEIVE_MMS", 23);
        VIRTUAL_PERMISSION_LIST.add("android.permission.NOTIFICATION_SERVICE");
        VIRTUAL_PERMISSION_LIST.add("android.permission.BIND_NOTIFICATION_LISTENER_SERVICE");
        VIRTUAL_PERMISSION_LIST.add("android.permission.BIND_VPN_SERVICE");
        VIRTUAL_PERMISSION_LIST.add("android.permission.PICTURE_IN_PICTURE");
    }
}

