/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.OnPermissionInterceptor;
import com.hjq.permissions.PermissionApi;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.StartActivityManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public final class PermissionFragment
extends Fragment
implements Runnable {
    private static final String REQUEST_PERMISSIONS = "request_permissions";
    private static final String REQUEST_CODE = "request_code";
    private static final List<Integer> REQUEST_CODE_ARRAY = new ArrayList<Integer>();
    private boolean mSpecialRequest;
    private boolean mDangerousRequest;
    private boolean mRequestFlag;
    @Nullable
    private OnPermissionCallback mCallBack;
    @Nullable
    private OnPermissionInterceptor mInterceptor;
    private int mScreenOrientation;

    public static void launch(@NonNull Activity activity, @NonNull List<String> permissions, @NonNull OnPermissionInterceptor interceptor, @Nullable OnPermissionCallback callback) {
        int requestCode;
        PermissionFragment fragment = new PermissionFragment();
        Random random = new Random();
        while (REQUEST_CODE_ARRAY.contains(requestCode = random.nextInt((int)Math.pow(2.0, 8.0)))) {
        }
        REQUEST_CODE_ARRAY.add(requestCode);
        Bundle bundle = new Bundle();
        bundle.putInt(REQUEST_CODE, requestCode);
        if (permissions instanceof ArrayList) {
            bundle.putStringArrayList(REQUEST_PERMISSIONS, (ArrayList)permissions);
        } else {
            bundle.putStringArrayList(REQUEST_PERMISSIONS, new ArrayList<String>(permissions));
        }
        fragment.setArguments(bundle);
        fragment.setRetainInstance(true);
        fragment.setRequestFlag(true);
        fragment.setOnPermissionCallback(callback);
        fragment.setOnPermissionInterceptor(interceptor);
        fragment.attachByActivity(activity);
    }

    public void attachByActivity(@NonNull Activity activity) {
        FragmentManager fragmentManager = activity.getFragmentManager();
        if (fragmentManager == null) {
            return;
        }
        fragmentManager.beginTransaction().add((Fragment)this, this.toString()).commitAllowingStateLoss();
    }

    public void detachByActivity(@NonNull Activity activity) {
        FragmentManager fragmentManager = activity.getFragmentManager();
        if (fragmentManager == null) {
            return;
        }
        fragmentManager.beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
    }

    public void setOnPermissionCallback(@Nullable OnPermissionCallback callback) {
        this.mCallBack = callback;
    }

    public void setRequestFlag(boolean flag) {
        this.mRequestFlag = flag;
    }

    public void setOnPermissionInterceptor(@Nullable OnPermissionInterceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public void onAttach(Context context) {
        super.onAttach(context);
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        this.mScreenOrientation = activity.getRequestedOrientation();
        if (this.mScreenOrientation != -1) {
            return;
        }
        PermissionUtils.lockActivityOrientation(activity);
    }

    public void onDetach() {
        super.onDetach();
        Activity activity = this.getActivity();
        if (activity == null || this.mScreenOrientation != -1 || activity.getRequestedOrientation() == -1) {
            return;
        }
        activity.setRequestedOrientation(-1);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCallBack = null;
    }

    public void onResume() {
        super.onResume();
        if (!this.mRequestFlag) {
            this.detachByActivity(this.getActivity());
            return;
        }
        if (this.mSpecialRequest) {
            return;
        }
        this.mSpecialRequest = true;
        this.requestSpecialPermission();
    }

    public void requestSpecialPermission() {
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (arguments == null || activity == null) {
            return;
        }
        ArrayList allPermissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        if (allPermissions == null || allPermissions.isEmpty()) {
            return;
        }
        boolean requestSpecialPermission = false;
        for (int i = allPermissions.size() - 1; i >= 0; --i) {
            String permission2 = (String)allPermissions.get(i);
            if (!PermissionApi.isSpecialPermission(permission2) || PermissionApi.isGrantedPermission((Context)activity, permission2) || !AndroidVersion.isAndroid11() && PermissionUtils.equalsPermission(permission2, "android.permission.MANAGE_EXTERNAL_STORAGE")) continue;
            StartActivityManager.startActivityForResult(this, PermissionApi.getSmartPermissionIntent((Context)activity, PermissionUtils.asArrayList(permission2)), this.getArguments().getInt(REQUEST_CODE));
            requestSpecialPermission = true;
        }
        if (requestSpecialPermission) {
            return;
        }
        this.requestDangerousPermission();
    }

    public void requestDangerousPermission() {
        Activity activity = this.getActivity();
        Bundle arguments = this.getArguments();
        if (activity == null || arguments == null) {
            return;
        }
        int requestCode = arguments.getInt(REQUEST_CODE);
        ArrayList allPermissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        if (allPermissions == null || allPermissions.isEmpty()) {
            return;
        }
        if (!AndroidVersion.isAndroid6()) {
            int[] grantResults = new int[allPermissions.size()];
            for (int i = 0; i < grantResults.length; ++i) {
                grantResults[i] = PermissionApi.isGrantedPermission((Context)activity, (String)allPermissions.get(i)) ? 0 : -1;
            }
            this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
            return;
        }
        if (AndroidVersion.isAndroid13() && allPermissions.size() >= 2 && PermissionUtils.containsPermission(allPermissions, "android.permission.BODY_SENSORS_BACKGROUND")) {
            ArrayList<String> bodySensorsPermission = new ArrayList<String>(allPermissions);
            bodySensorsPermission.remove("android.permission.BODY_SENSORS_BACKGROUND");
            this.splitTwiceRequestPermission(activity, allPermissions, bodySensorsPermission, requestCode);
            return;
        }
        if (AndroidVersion.isAndroid10() && allPermissions.size() >= 2 && PermissionUtils.containsPermission(allPermissions, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            ArrayList<String> locationPermission = new ArrayList<String>(allPermissions);
            locationPermission.remove("android.permission.ACCESS_BACKGROUND_LOCATION");
            this.splitTwiceRequestPermission(activity, allPermissions, locationPermission, requestCode);
            return;
        }
        if (AndroidVersion.isAndroid10() && PermissionUtils.containsPermission(allPermissions, "android.permission.ACCESS_MEDIA_LOCATION") && PermissionUtils.containsPermission(allPermissions, "android.permission.READ_EXTERNAL_STORAGE")) {
            ArrayList<String> storagePermission = new ArrayList<String>(allPermissions);
            storagePermission.remove("android.permission.ACCESS_MEDIA_LOCATION");
            this.splitTwiceRequestPermission(activity, allPermissions, storagePermission, requestCode);
            return;
        }
        this.requestPermissions(allPermissions.toArray(new String[allPermissions.size() - 1]), requestCode);
    }

    public void splitTwiceRequestPermission(final @NonNull Activity activity, final @NonNull List<String> allPermissions, @NonNull List<String> firstPermissions, final int requestCode) {
        final ArrayList<String> secondPermissions = new ArrayList<String>(allPermissions);
        for (String permission2 : firstPermissions) {
            secondPermissions.remove(permission2);
        }
        PermissionFragment.launch(activity, firstPermissions, new OnPermissionInterceptor(){}, new OnPermissionCallback(){

            @Override
            public void onGranted(@NonNull List<String> permissions, boolean allGranted) {
                if (!allGranted || !PermissionFragment.this.isAdded()) {
                    return;
                }
                long delayMillis = AndroidVersion.isAndroid13() ? 150L : 0L;
                PermissionUtils.postDelayed(() -> PermissionFragment.launch(activity, secondPermissions, new OnPermissionInterceptor(){}, new OnPermissionCallback(){

                    @Override
                    public void onGranted(@NonNull List<String> permissions, boolean allGranted) {
                        if (!allGranted || !PermissionFragment.this.isAdded()) {
                            return;
                        }
                        int[] grantResults = new int[allPermissions.size()];
                        Arrays.fill(grantResults, 0);
                        PermissionFragment.this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
                    }

                    @Override
                    public void onDenied(@NonNull List<String> permissions, boolean doNotAskAgain) {
                        if (!PermissionFragment.this.isAdded()) {
                            return;
                        }
                        int[] grantResults = new int[allPermissions.size()];
                        for (int i = 0; i < allPermissions.size(); ++i) {
                            grantResults[i] = PermissionUtils.containsPermission(secondPermissions, (String)allPermissions.get(i)) ? -1 : 0;
                        }
                        PermissionFragment.this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
                    }
                }), delayMillis);
            }

            @Override
            public void onDenied(@NonNull List<String> permissions, boolean doNotAskAgain) {
                if (!PermissionFragment.this.isAdded()) {
                    return;
                }
                int[] grantResults = new int[allPermissions.size()];
                Arrays.fill(grantResults, -1);
                PermissionFragment.this.onRequestPermissionsResult(requestCode, allPermissions.toArray(new String[0]), grantResults);
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Bundle arguments = this.getArguments();
        Activity activity = this.getActivity();
        if (activity == null || arguments == null || this.mInterceptor == null || requestCode != arguments.getInt(REQUEST_CODE)) {
            return;
        }
        OnPermissionCallback callback = this.mCallBack;
        this.mCallBack = null;
        OnPermissionInterceptor interceptor = this.mInterceptor;
        this.mInterceptor = null;
        REQUEST_CODE_ARRAY.remove((Object)requestCode);
        if (permissions == null || permissions.length == 0 || grantResults == null || grantResults.length == 0) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            grantResults[i] = PermissionApi.recheckPermissionResult((Context)activity, permissions[i], grantResults[i] == 0) ? 0 : -1;
        }
        ArrayList<String> allPermissions = PermissionUtils.asArrayList(permissions);
        this.detachByActivity(activity);
        List<String> grantedPermissions = PermissionApi.getGrantedPermissions(allPermissions, grantResults);
        if (grantedPermissions.size() == allPermissions.size()) {
            interceptor.grantedPermissionRequest(activity, allPermissions, grantedPermissions, true, callback);
            interceptor.finishPermissionRequest(activity, allPermissions, false, callback);
            return;
        }
        List<String> deniedPermissions = PermissionApi.getDeniedPermissions(allPermissions, grantResults);
        interceptor.deniedPermissionRequest(activity, allPermissions, deniedPermissions, PermissionApi.isDoNotAskAgainPermissions(activity, deniedPermissions), callback);
        if (!grantedPermissions.isEmpty()) {
            interceptor.grantedPermissionRequest(activity, allPermissions, grantedPermissions, false, callback);
        }
        interceptor.finishPermissionRequest(activity, allPermissions, false, callback);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        Activity activity = this.getActivity();
        Bundle arguments = this.getArguments();
        if (activity == null || arguments == null || this.mDangerousRequest || requestCode != arguments.getInt(REQUEST_CODE)) {
            return;
        }
        ArrayList allPermissions = arguments.getStringArrayList(REQUEST_PERMISSIONS);
        if (allPermissions == null || allPermissions.isEmpty()) {
            return;
        }
        this.mDangerousRequest = true;
        PermissionUtils.postActivityResult(allPermissions, this);
    }

    @Override
    public void run() {
        if (!this.isAdded()) {
            return;
        }
        this.requestDangerousPermission();
    }
}

