/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.hjq.permissions.ManifestPermissionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class PermissionUtils {
    PermissionUtils() {
    }

    static String[] getManifestPermissions(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            return pm.getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    static boolean isOverMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    static ArrayList<String> getFailPermissions(Context context, String[] permissions) {
        if (!PermissionUtils.isOverMarshmallow()) {
            return null;
        }
        ArrayList<String> failPermissions = null;
        for (String permission : permissions) {
            if (context.checkSelfPermission(permission) != -1) continue;
            if (failPermissions == null) {
                failPermissions = new ArrayList<String>();
            }
            failPermissions.add(permission);
        }
        return failPermissions;
    }

    static List<String> getFailPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> failPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1) continue;
            failPermissions.add(permissions[i]);
        }
        return failPermissions;
    }

    static List<String> getSucceedPermissions(String[] permissions, int[] grantResults) {
        ArrayList<String> succeedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            succeedPermissions.add(permissions[i]);
        }
        return succeedPermissions;
    }

    static void checkPermissions(Activity activity, String[] requestPermissions) {
        String[] permissions = PermissionUtils.getManifestPermissions((Context)activity);
        if (permissions != null && permissions.length != 0) {
            List<String> manifest = Arrays.asList(permissions);
            for (String permission : requestPermissions) {
                if (manifest.contains(permission)) continue;
                throw new ManifestPermissionException(permission);
            }
        } else {
            throw new ManifestPermissionException(null);
        }
    }
}

