/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.NotificationPermissionCompat;
import com.hjq.permissions.PermissionDelegateImplV31;
import com.hjq.permissions.PermissionUtils;

@RequiresApi(api=33)
class PermissionDelegateImplV33
extends PermissionDelegateImplV31 {
    PermissionDelegateImplV33() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission) {
        if (PermissionUtils.equalsPermission(permission, "android.permission.BODY_SENSORS_BACKGROUND")) {
            return PermissionUtils.checkSelfPermission(context, "android.permission.BODY_SENSORS") && PermissionUtils.checkSelfPermission(context, "android.permission.BODY_SENSORS_BACKGROUND");
        }
        if (PermissionUtils.containsPermission(new String[]{"android.permission.POST_NOTIFICATIONS", "android.permission.NEARBY_WIFI_DEVICES", "android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_AUDIO"}, permission)) {
            return PermissionUtils.checkSelfPermission(context, permission);
        }
        if (AndroidVersion.getTargetSdkVersionCode(context) >= 33) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                return true;
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.READ_EXTERNAL_STORAGE")) {
                return PermissionUtils.checkSelfPermission(context, "android.permission.READ_MEDIA_IMAGES") && PermissionUtils.checkSelfPermission(context, "android.permission.READ_MEDIA_VIDEO") && PermissionUtils.checkSelfPermission(context, "android.permission.READ_MEDIA_AUDIO");
            }
        }
        return super.isGrantedPermission(context, permission);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission) {
        if (PermissionUtils.equalsPermission(permission, "android.permission.BODY_SENSORS_BACKGROUND")) {
            if (!PermissionUtils.checkSelfPermission((Context)activity, "android.permission.BODY_SENSORS")) {
                return !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.BODY_SENSORS");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission);
        }
        if (PermissionUtils.containsPermission(new String[]{"android.permission.POST_NOTIFICATIONS", "android.permission.NEARBY_WIFI_DEVICES", "android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_AUDIO"}, permission)) {
            return !PermissionUtils.checkSelfPermission((Context)activity, permission) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission);
        }
        if (AndroidVersion.getTargetSdkVersionCode((Context)activity) >= 33) {
            if (PermissionUtils.equalsPermission(permission, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                return false;
            }
            if (PermissionUtils.equalsPermission(permission, "android.permission.READ_EXTERNAL_STORAGE")) {
                return !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_MEDIA_IMAGES") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_MEDIA_IMAGES") && !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_MEDIA_VIDEO") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_MEDIA_VIDEO") && !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.READ_MEDIA_AUDIO") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.READ_MEDIA_AUDIO");
            }
        }
        return super.isDoNotAskAgainPermission(activity, permission);
    }

    @Override
    public Intent getPermissionIntent(@NonNull Context context, @NonNull String permission) {
        if (PermissionUtils.equalsPermission(permission, "android.permission.POST_NOTIFICATIONS")) {
            return NotificationPermissionCompat.getPermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission);
    }
}

