/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.app.AlarmManager;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.PermissionDelegateImplV30;
import com.hjq.permissions.PermissionIntentManager;
import com.hjq.permissions.PermissionUtils;

@RequiresApi(api=31)
class PermissionDelegateImplV31
extends PermissionDelegateImplV30 {
    PermissionDelegateImplV31() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            return PermissionDelegateImplV31.isGrantedAlarmPermission(context);
        }
        if (PermissionUtils.containsPermission(new String[]{"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_ADVERTISE"}, permission2)) {
            return PermissionUtils.checkSelfPermission(context, permission2);
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            return false;
        }
        if (PermissionUtils.containsPermission(new String[]{"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_ADVERTISE"}, permission2)) {
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        if (activity.getApplicationInfo().targetSdkVersion >= 31 && PermissionUtils.equalsPermission(permission2, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            if (!PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.checkSelfPermission((Context)activity, "android.permission.ACCESS_COARSE_LOCATION")) {
                return !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtils.shouldShowRequestPermissionRationale(activity, "android.permission.ACCESS_COARSE_LOCATION");
            }
            return !PermissionUtils.checkSelfPermission((Context)activity, permission2) && !PermissionUtils.shouldShowRequestPermissionRationale(activity, permission2);
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public Intent getPermissionIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SCHEDULE_EXACT_ALARM")) {
            return PermissionDelegateImplV31.getAlarmPermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission2);
    }

    private static boolean isGrantedAlarmPermission(@NonNull Context context) {
        return ((AlarmManager)context.getSystemService(AlarmManager.class)).canScheduleExactAlarms();
    }

    private static Intent getAlarmPermissionIntent(@NonNull Context context) {
        Intent intent = new Intent("android.settings.REQUEST_SCHEDULE_EXACT_ALARM");
        intent.setData(PermissionUtils.getPackageNameUri(context));
        if (!PermissionUtils.areActivityIntent(context, intent)) {
            intent = PermissionIntentManager.getApplicationDetailsIntent(context);
        }
        return intent;
    }
}

