/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.hjq.permissions.AndroidVersion;
import com.hjq.permissions.GetInstalledAppsPermissionCompat;
import com.hjq.permissions.NotificationPermissionCompat;
import com.hjq.permissions.PermissionDelegateImplV18;
import com.hjq.permissions.PermissionUtils;
import com.hjq.permissions.WindowPermissionCompat;

@RequiresApi(api=19)
class PermissionDelegateImplV19
extends PermissionDelegateImplV18 {
    PermissionDelegateImplV19() {
    }

    @Override
    public boolean isGrantedPermission(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SYSTEM_ALERT_WINDOW")) {
            return WindowPermissionCompat.isGrantedPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "com.android.permission.GET_INSTALLED_APPS")) {
            return GetInstalledAppsPermissionCompat.isGrantedPermission(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.NOTIFICATION_SERVICE")) {
            return NotificationPermissionCompat.isGrantedPermission(context);
        }
        if (!AndroidVersion.isAndroid13() && PermissionUtils.equalsPermission(permission2, "android.permission.POST_NOTIFICATIONS")) {
            return NotificationPermissionCompat.isGrantedPermission(context);
        }
        return super.isGrantedPermission(context, permission2);
    }

    @Override
    public boolean isDoNotAskAgainPermission(@NonNull Activity activity, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SYSTEM_ALERT_WINDOW")) {
            return false;
        }
        if (PermissionUtils.equalsPermission(permission2, "com.android.permission.GET_INSTALLED_APPS")) {
            return GetInstalledAppsPermissionCompat.isDoNotAskAgainPermission(activity);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.NOTIFICATION_SERVICE")) {
            return false;
        }
        if (!AndroidVersion.isAndroid13() && PermissionUtils.equalsPermission(permission2, "android.permission.POST_NOTIFICATIONS")) {
            return false;
        }
        return super.isDoNotAskAgainPermission(activity, permission2);
    }

    @Override
    public Intent getPermissionIntent(@NonNull Context context, @NonNull String permission2) {
        if (PermissionUtils.equalsPermission(permission2, "android.permission.SYSTEM_ALERT_WINDOW")) {
            return WindowPermissionCompat.getPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "com.android.permission.GET_INSTALLED_APPS")) {
            return GetInstalledAppsPermissionCompat.getPermissionIntent(context);
        }
        if (PermissionUtils.equalsPermission(permission2, "android.permission.NOTIFICATION_SERVICE")) {
            return NotificationPermissionCompat.getPermissionIntent(context);
        }
        if (!AndroidVersion.isAndroid13() && PermissionUtils.equalsPermission(permission2, "android.permission.POST_NOTIFICATIONS")) {
            return NotificationPermissionCompat.getPermissionIntent(context);
        }
        return super.getPermissionIntent(context, permission2);
    }
}

