/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.permissions;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.permissions.OnPermissionCallback;
import com.hjq.permissions.PermissionFragment;
import java.util.List;

public interface OnPermissionInterceptor {
    default public void launchPermissionRequest(@NonNull Activity activity, @NonNull List<String> allPermissions, @Nullable OnPermissionCallback callback) {
        PermissionFragment.launch(activity, allPermissions, this, callback);
    }

    default public void grantedPermissionRequest(@NonNull Activity activity, @NonNull List<String> allPermissions, @NonNull List<String> grantedPermissions, boolean allGranted, @Nullable OnPermissionCallback callback) {
        if (callback == null) {
            return;
        }
        callback.onGranted(grantedPermissions, allGranted);
    }

    default public void deniedPermissionRequest(@NonNull Activity activity, @NonNull List<String> allPermissions, @NonNull List<String> deniedPermissions, boolean doNotAskAgain, @Nullable OnPermissionCallback callback) {
        if (callback == null) {
            return;
        }
        callback.onDenied(deniedPermissions, doNotAskAgain);
    }

    default public void finishPermissionRequest(@NonNull Activity activity, @NonNull List<String> allPermissions, boolean skipRequest, @Nullable OnPermissionCallback callback) {
    }
}

